/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueFiller;
import org.codehaus.swizzle.jira.Jira;
import org.codehaus.swizzle.jira.JiraRss;
import org.codehaus.swizzle.jira.MapObjectList;
import org.codehaus.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.codehaus.swizzle.stream.IncludeFilterInputStream;
import org.codehaus.swizzle.stream.ReplaceStringInputStream;
import org.codehaus.swizzle.stream.StreamTokenHandler;
import org.codehaus.swizzle.stream.StringTokenHandler;

public class SubTasksFiller
implements IssueFiller {
    private final Jira jira;
    private boolean enabled;

    public SubTasksFiller(Jira jira) {
        this.jira = jira;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void fill(Issue issue) {
        if (!this.enabled) {
            return;
        }
        if (issue.getParentTask() != null) {
            return;
        }
        List issueKeys = this.getSubTasks(issue);
        issueKeys.remove(issue.getKey());
        for (int i = 0; i < issueKeys.size(); ++i) {
            String issueKey = (String)issueKeys.get(i);
            Issue subTask = this.jira.getIssue(issueKey);
            issue.getSubTasks().add(subTask);
        }
    }

    public static void main(String[] args) throws Exception {
        JiraRss jiraRss = new JiraRss("http://jira.codehaus.org/browse/OPENEJB-90?decorator=none&view=rss");
        SubTasksFiller.fill(jiraRss);
    }

    public static List fill(JiraRss jiraRss) throws Exception {
        SubTasksFiller filler = new SubTasksFiller(null);
        MapObjectList issues = (MapObjectList)jiraRss.getIssues();
        issues = issues.ascending("id");
        for (int i = 0; i < issues.size(); ++i) {
            Issue issue = (Issue)issues.get(i);
            if (issue.getParentTask() != null) continue;
            String link = issue.getLink();
            link = link.replaceFirst("/browse/.*$", "/");
            List issueKeys = filler.getSubTasks(issue);
            issueKeys.remove(issue.getKey());
            for (int j = 0; j < issueKeys.size(); ++j) {
                String issueKey = (String)issueKeys.get(j);
                Issue subTask = jiraRss.getIssue(issueKey);
                if (subTask != null) {
                    issue.getSubTasks().add(subTask);
                    subTask.setParentTask(issue);
                    continue;
                }
                URL issueRssUrl = new URL(link + "browse/" + issueKey + "?decorator=none&view=rss");
                JiraRss subtaskJiraRss = new JiraRss(issueRssUrl);
                subTask = subtaskJiraRss.getIssue(issueKey);
                if (subTask == null) continue;
                issue.getSubTasks().add(subTask);
                subTask.setParentTask(issue);
            }
        }
        return issues;
    }

    private List getSubTasks(Issue issue) {
        try {
            URL url = new URL(issue.getLink() + "?subTaskView=all");
            ArrayList issueIds = new ArrayList();
            Object in = new BufferedInputStream(url.openStream());
            in = new ReplaceStringInputStream((InputStream)in, " ", "");
            in = new ReplaceStringInputStream((InputStream)in, "\t", "");
            in = new ReplaceStringInputStream((InputStream)in, "\n", "");
            in = new ReplaceStringInputStream((InputStream)in, "\r", "");
            in = new ReplaceStringInputStream((InputStream)in, "<tr", "\n<tr");
            in = new ReplaceStringInputStream((InputStream)in, "</tr>", "</tr>\n");
            in = new GrepStream((InputStream)in, "issue_subtask.gif");
            in = new IncludeFilterInputStream((InputStream)in, "<ahref", ">");
            in = new DelimitedTokenReplacementInputStream((InputStream)in, "browse/", "\"", (StreamTokenHandler)new CollectTokensHandler(issueIds));
            int i = ((InputStream)in).read();
            while (i != -1) {
                i = ((InputStream)in).read();
            }
            ((InputStream)in).close();
            return issueIds;
        }
        catch (IOException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            return new ArrayList();
        }
    }

    public static class CollectTokensHandler
    extends StringTokenHandler {
        private final Collection collection;
        private Pattern pattern = Pattern.compile(".*?([A-Za-z]+-[0-9]+).*");

        public CollectTokensHandler(Collection collection) {
            this.collection = collection;
        }

        public String handleToken(String token) throws IOException {
            Matcher matcher = this.pattern.matcher(token);
            boolean b = matcher.find();
            token = matcher.group(1);
            if (!this.collection.contains(token)) {
                this.collection.add(token);
            }
            return token;
        }
    }

    public static class GrepStream
    extends DelimitedTokenReplacementInputStream {
        public GrepStream(InputStream in, String match, String lineTerminator) {
            super(in, "<", lineTerminator, (StreamTokenHandler)new LineMatcher(match, lineTerminator));
        }

        public GrepStream(InputStream in, String match) {
            this(in, match, "\n");
        }

        public GrepStream(InputStream in, String begin, String end, StreamTokenHandler tokenHandler, boolean caseSensitive) {
            super(in, begin, end, tokenHandler, caseSensitive);
        }

        public static class LineMatcher
        extends StringTokenHandler {
            private final String match;
            private final String lineTerminator;

            public LineMatcher(String match, String lineTerminator) {
                this.match = match;
                this.lineTerminator = lineTerminator;
            }

            public String handleToken(String token) throws IOException {
                if (token.indexOf(this.match) == -1) {
                    return "";
                }
                return "<" + token + this.lineTerminator;
            }
        }
    }
}

