/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.soap;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl11.WSDL11Transport;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;

public class Soap11Binding
extends AbstractSoapBinding {
    public Soap11Binding(QName name, String bindingId, Service serviceInfo) {
        super(name, bindingId, serviceInfo);
    }

    public SoapVersion getSoapVersion() {
        return Soap11.getInstance();
    }

    public Binding createBinding(WSDLBuilder builder, PortType portType) {
        Transport t = builder.getTransportManager().getTransport(this.getBindingId());
        if (!(t instanceof WSDL11Transport)) {
            return null;
        }
        Definition def = builder.getDefinition();
        Binding wbinding = def.createBinding();
        wbinding.setQName(this.getName());
        wbinding.setPortType(portType);
        wbinding.setUndefined(false);
        wbinding.addExtensibilityElement((ExtensibilityElement)this.createSoapBinding());
        Iterator oitr = this.getService().getServiceInfo().getOperations().iterator();
        while (oitr.hasNext()) {
            OperationInfo op = (OperationInfo)oitr.next();
            Operation wsdlOp = portType.getOperation(op.getName(), null, null);
            BindingOperation bop = this.createBindingOperation(builder, wsdlOp, op);
            this.createHeaders(builder, op, bop);
            wbinding.addBindingOperation(bop);
        }
        def.addBinding(wbinding);
        return wbinding;
    }

    protected BindingOperation createBindingOperation(WSDLBuilder builder, Operation wsdlOp, OperationInfo op) {
        Map faults;
        Definition def = builder.getDefinition();
        BindingOperation wbindOp = def.createBindingOperation();
        SOAPBody body = this.createSoapBody(builder.getService());
        SOAPOperationImpl soapOp = new SOAPOperationImpl();
        soapOp.setSoapActionURI(this.getSoapAction(op));
        BindingInput bindIn = def.createBindingInput();
        bindIn.setName(op.getInputMessage().getName().getLocalPart());
        bindIn.addExtensibilityElement((ExtensibilityElement)body);
        wbindOp.setBindingInput(bindIn);
        if (wsdlOp.getOutput() != null) {
            BindingOutput bindOut = builder.getDefinition().createBindingOutput();
            bindOut.setName(wsdlOp.getOutput().getName());
            bindOut.addExtensibilityElement((ExtensibilityElement)body);
            wbindOp.setBindingOutput(bindOut);
        }
        if ((faults = wsdlOp.getFaults()) != null) {
            Iterator itr = faults.values().iterator();
            while (itr.hasNext()) {
                Fault fault = (Fault)itr.next();
                BindingFault bindingFault = def.createBindingFault();
                bindingFault.setName(fault.getName());
                SOAPFault soapFault = this.createSoapFault(builder.getService());
                soapFault.setName(fault.getName());
                bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
                wbindOp.addBindingFault(bindingFault);
            }
        }
        wbindOp.setName(wsdlOp.getName());
        wbindOp.setOperation(wsdlOp);
        wbindOp.addExtensibilityElement((ExtensibilityElement)soapOp);
        return wbindOp;
    }

    protected void createHeaders(WSDLBuilder builder, OperationInfo op, BindingOperation bop) {
        SOAPHeaderImpl soapHeader;
        Part headerInfo;
        Iterator headerItr;
        if (op.getInputMessage() != null) {
            List inputHeaders = this.getHeaders(op.getInputMessage()).getMessageParts();
            BindingInput bindingInput = bop.getBindingInput();
            if (inputHeaders.size() > 0) {
                Message reqHeaders = this.createHeaderMessages(builder, op.getInputMessage(), inputHeaders);
                builder.getDefinition().addMessage(reqHeaders);
                headerItr = reqHeaders.getParts().values().iterator();
                while (headerItr.hasNext()) {
                    headerInfo = (Part)headerItr.next();
                    soapHeader = new SOAPHeaderImpl();
                    soapHeader.setMessage(reqHeaders.getQName());
                    soapHeader.setPart(headerInfo.getName());
                    soapHeader.setUse(this.getUse());
                    bindingInput.addExtensibilityElement((ExtensibilityElement)soapHeader);
                }
            }
        }
        if (op.getOutputMessage() != null) {
            List outputHeaders = this.getHeaders(op.getOutputMessage()).getMessageParts();
            BindingOutput bindingOutput = bop.getBindingOutput();
            if (outputHeaders.size() > 0) {
                Message resHeaders = this.createHeaderMessages(builder, op.getOutputMessage(), outputHeaders);
                builder.getDefinition().addMessage(resHeaders);
                headerItr = resHeaders.getParts().values().iterator();
                while (headerItr.hasNext()) {
                    headerInfo = (Part)headerItr.next();
                    soapHeader = new SOAPHeaderImpl();
                    soapHeader.setMessage(resHeaders.getQName());
                    soapHeader.setPart(headerInfo.getName());
                    soapHeader.setUse(this.getUse());
                    bindingOutput.addExtensibilityElement((ExtensibilityElement)soapHeader);
                }
            }
        }
    }

    protected Message createHeaderMessages(WSDLBuilder builder, MessageInfo msgInfo, List headers) {
        Message msg = builder.getDefinition().createMessage();
        msg.setQName(new QName(builder.getTargetNamespace(), msgInfo.getName().getLocalPart() + "Headers"));
        msg.setUndefined(false);
        Iterator itr = headers.iterator();
        while (itr.hasNext()) {
            MessagePartInfo header = (MessagePartInfo)itr.next();
            Part part = builder.createPart(header);
            msg.addPart(part);
        }
        return msg;
    }

    protected SOAPFault createSoapFault(Service endpoint) {
        String use = this.getUse();
        SOAPFaultImpl fault = new SOAPFaultImpl();
        fault.setUse(use);
        if (use.equals("encoded")) {
            ArrayList<String> encodingStyles = new ArrayList<String>();
            encodingStyles.add(this.getSoapVersion().getSoapEncodingStyle());
            fault.setEncodingStyles(encodingStyles);
        }
        return fault;
    }

    protected SOAPHeader createSoapHeader(Service endpoint) {
        String use = this.getUse();
        SOAPHeaderImpl header = new SOAPHeaderImpl();
        header.setUse(use);
        if (use.equals("encoded")) {
            ArrayList<String> encodingStyles = new ArrayList<String>();
            encodingStyles.add(this.getSoapVersion().getSoapEncodingStyle());
            header.setEncodingStyles(encodingStyles);
        }
        return header;
    }

    protected SOAPBinding createSoapBinding() {
        SOAPBindingImpl soapBind = new SOAPBindingImpl();
        String style = this.getStyle();
        if (style.equals("wrapped")) {
            style = "document";
        }
        soapBind.setStyle(style);
        soapBind.setTransportURI(this.getBindingId());
        return soapBind;
    }

    protected SOAPBody createSoapBody(Service service) {
        String use = this.getUse();
        SOAPBodyImpl body = new SOAPBodyImpl();
        body.setUse(use);
        if (this.getStyle().equals("rpc")) {
            body.setNamespaceURI(service.getTargetNamespace());
        }
        if (use.equals("encoded")) {
            ArrayList<String> encodingStyles = new ArrayList<String>();
            encodingStyles.add(this.getSoapVersion().getSoapEncodingStyle());
            body.setEncodingStyles(encodingStyles);
        }
        return body;
    }

    public Port createPort(Endpoint endpoint, WSDLBuilder builder, Binding wbinding) {
        SOAPAddressImpl add = new SOAPAddressImpl();
        add.setLocationURI(endpoint.getUrl());
        Port port = builder.getDefinition().createPort();
        port.setBinding(wbinding);
        port.setName(endpoint.getName().getLocalPart());
        port.addExtensibilityElement((ExtensibilityElement)add);
        return port;
    }

    public Port createPort(WSDLBuilder builder, Binding wbinding) {
        Transport t = builder.getTransportManager().getTransport(this.getBindingId());
        if (!(t instanceof WSDL11Transport)) {
            return null;
        }
        WSDL11Transport transport = (WSDL11Transport)t;
        SOAPAddressImpl add = new SOAPAddressImpl();
        add.setLocationURI(transport.getServiceURL(builder.getService()));
        Port port = builder.getDefinition().createPort();
        port.setBinding(wbinding);
        port.setName(builder.getService().getSimpleName() + transport.getName() + "Port");
        port.addExtensibilityElement((ExtensibilityElement)add);
        return port;
    }
}

