/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.DatagramChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.client.BayeuxClient;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OortMulticastConfigurer
extends AbstractLifeCycle {
    private static final AtomicInteger ids = new AtomicInteger();
    private final Logger logger;
    private final Oort oort;
    private InetAddress bindAddress;
    private InetAddress groupAddress;
    private List<NetworkInterface> groupInterfaces;
    private int groupPort = 5577;
    private int timeToLive = 1;
    private long advertiseInterval = 2000L;
    private long connectTimeout = 2000L;
    private int maxTransmissionLength = 1400;
    private Thread receiverThread;
    private Thread senderThread;
    private volatile boolean active;

    public OortMulticastConfigurer(Oort oort) {
        this.logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Oort.replacePunctuation(oort.getURL(), '_')));
        this.oort = oort;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public InetAddress getGroupAddress() {
        return this.groupAddress;
    }

    public void setGroupAddress(InetAddress groupAddress) {
        this.groupAddress = groupAddress;
    }

    public int getGroupPort() {
        return this.groupPort;
    }

    public void setGroupPort(int groupPort) {
        this.groupPort = groupPort;
    }

    public List<NetworkInterface> getGroupInterfaces() {
        return this.groupInterfaces;
    }

    public void setGroupInterfaces(List<NetworkInterface> groupInterfaces) {
        this.groupInterfaces = groupInterfaces;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public long getAdvertiseInterval() {
        return this.advertiseInterval;
    }

    public void setAdvertiseInterval(long advertiseInterval) {
        this.advertiseInterval = advertiseInterval;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getMaxTransmissionLength() {
        return this.maxTransmissionLength;
    }

    public void setMaxTransmissionLength(int maxTransmissionLength) {
        this.maxTransmissionLength = maxTransmissionLength;
    }

    protected void doStart() throws Exception {
        List<NetworkInterface> groupInterfaces;
        InetAddress bindTo;
        DatagramChannel sender = DatagramChannel.open();
        sender.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.getTimeToLive());
        if (this.groupAddress == null) {
            this.groupAddress = InetAddress.getByName("239.255.0.1");
        }
        StandardProtocolFamily protocolFamily = StandardProtocolFamily.INET;
        if (this.groupAddress instanceof Inet6Address) {
            protocolFamily = StandardProtocolFamily.INET6;
        }
        InetSocketAddress bindSocketAddress = (bindTo = this.getBindAddress()) == null ? new InetSocketAddress(this.groupPort) : new InetSocketAddress(bindTo, this.groupPort);
        DatagramChannel receiver = ((DatagramChannel)DatagramChannel.open(protocolFamily).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(bindSocketAddress);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound multicast receiver to {} with protocol family {}", (Object)bindSocketAddress, (Object)protocolFamily);
        }
        if ((groupInterfaces = this.getGroupInterfaces()) == null) {
            groupInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        boolean joined = false;
        for (NetworkInterface groupInterface : groupInterfaces) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Joining multicast group with {}", (Object)groupInterface);
            }
            if (groupInterface.isLoopback() || groupInterface.isPointToPoint() || !groupInterface.supportsMulticast() || !groupInterface.getInetAddresses().hasMoreElements()) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Skipped joining multicast group with {}", (Object)groupInterface);
                continue;
            }
            try {
                receiver.join(this.groupAddress, groupInterface);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Joined multicast group with {}", (Object)groupInterface);
                }
                joined = true;
            }
            catch (Exception x) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Exception joining multicast group with " + String.valueOf(groupInterface), (Throwable)x);
            }
        }
        if (!joined) {
            throw new IOException("Could not join multicast group with " + String.valueOf(groupInterfaces));
        }
        this.active = true;
        this.senderThread = new Thread((Runnable)new MulticastSender(sender), "Oort-Multicast-Sender-" + ids.incrementAndGet());
        this.senderThread.setDaemon(true);
        this.senderThread.start();
        this.receiverThread = new Thread((Runnable)new MulticastReceiver(receiver), "Oort-Multicast-Receiver-" + ids.incrementAndGet());
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
    }

    protected void doStop() {
        this.active = false;
        this.senderThread.interrupt();
        this.receiverThread.interrupt();
    }

    public boolean join(long timeout) {
        try {
            this.senderThread.join(timeout);
            this.receiverThread.join(timeout);
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    protected void receive(String cometURL) {
        if (!this.oort.getKnownComets().contains(cometURL)) {
            OortComet oortComet;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received comet URL via multicast: {}", (Object)cometURL);
            }
            if ((oortComet = this.oort.observeComet(cometURL)) != null) {
                boolean elapsed;
                boolean bl = elapsed = !oortComet.waitFor(this.getConnectTimeout(), BayeuxClient.State.CONNECTED, new BayeuxClient.State[]{BayeuxClient.State.DISCONNECTED});
                if (elapsed) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Interrupting attempts to connect to {}", (Object)cometURL);
                    }
                    this.oort.deobserveComet(cometURL);
                }
            }
        }
    }

    private void close(DatagramChannel channel) {
        block2: {
            try {
                channel.close();
            }
            catch (IOException x) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Could not close " + String.valueOf(channel), (Throwable)x);
            }
        }
    }

    private class MulticastSender
    implements Runnable {
        private final DatagramChannel channel;

        public MulticastSender(DatagramChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (OortMulticastConfigurer.this.logger.isDebugEnabled()) {
                OortMulticastConfigurer.this.logger.debug("Entering multicast sender thread");
            }
            try {
                String cometURL = OortMulticastConfigurer.this.oort.getURL();
                byte[] cometURLBytes = cometURL.getBytes(StandardCharsets.UTF_8);
                if (cometURLBytes.length > OortMulticastConfigurer.this.getMaxTransmissionLength()) {
                    OortMulticastConfigurer.this.logger.warn("Oort URL {} exceeds max transmission unit and will not be advertised", (Object)cometURL);
                    return;
                }
                ByteBuffer buffer = ByteBuffer.wrap(cometURLBytes);
                InetSocketAddress address = new InetSocketAddress(OortMulticastConfigurer.this.getGroupAddress(), OortMulticastConfigurer.this.getGroupPort());
                while (OortMulticastConfigurer.this.active) {
                    buffer.clear();
                    this.channel.send(buffer, address);
                    Thread.sleep(OortMulticastConfigurer.this.getAdvertiseInterval());
                }
            }
            catch (InterruptedException | ClosedByInterruptException cometURL) {
            }
            catch (IOException x) {
                OortMulticastConfigurer.this.logger.warn("Unexpected exception", (Throwable)x);
            }
            finally {
                if (OortMulticastConfigurer.this.logger.isDebugEnabled()) {
                    OortMulticastConfigurer.this.logger.debug("Exiting multicast sender thread");
                }
                OortMulticastConfigurer.this.close(this.channel);
            }
        }
    }

    private class MulticastReceiver
    implements Runnable {
        private final DatagramChannel channel;

        public MulticastReceiver(DatagramChannel channel) {
            this.channel = channel;
        }

        @Override
        public void run() {
            try {
                if (OortMulticastConfigurer.this.logger.isDebugEnabled()) {
                    OortMulticastConfigurer.this.logger.debug("Entering multicast receiver thread on {}", (Object)this.channel.getLocalAddress());
                }
                ByteBuffer buffer = ByteBuffer.allocate(OortMulticastConfigurer.this.getMaxTransmissionLength());
                String url = null;
                while (OortMulticastConfigurer.this.active) {
                    if (url != null) {
                        OortMulticastConfigurer.this.receive(url);
                    }
                    url = this.receive(buffer);
                    if (!OortMulticastConfigurer.this.oort.getURL().equals(url)) continue;
                    url = null;
                }
            }
            catch (ClosedByInterruptException buffer) {
            }
            catch (IOException x) {
                OortMulticastConfigurer.this.logger.warn("Unexpected exception", (Throwable)x);
            }
            finally {
                if (OortMulticastConfigurer.this.logger.isDebugEnabled()) {
                    OortMulticastConfigurer.this.logger.debug("Exiting multicast receiver thread");
                }
                OortMulticastConfigurer.this.close(this.channel);
            }
        }

        private String receive(ByteBuffer buffer) throws IOException {
            buffer.clear();
            this.channel.receive(buffer);
            buffer.flip();
            return StandardCharsets.UTF_8.decode(buffer).toString();
        }
    }
}

