/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort.jakarta;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import java.util.ArrayList;
import java.util.Map;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.client.transport.ClientTransport;
import org.cometd.common.JSONContext;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OortConfigServlet
extends HttpServlet {
    public static final String OORT_URL_PARAM = "oort.url";
    public static final String OORT_SECRET_PARAM = "oort.secret";
    public static final String OORT_CHANNELS_PARAM = "oort.channels";
    public static final String OORT_ENABLE_ACK_EXTENSION_PARAM = "enableAckExtension";
    public static final String OORT_ENABLE_BINARY_EXTENSION_PARAM = "enableBinaryExtension";
    public static final String OORT_JSON_CONTEXT_PARAM = "jsonContext";
    public static final String OORT_CLIENT_TRANSPORT_FACTORIES_PARAM = "clientTransportFactories";
    public static final String OORT_CONTEXT_ATTRIBUTE_NAME_PARAM = "oortContextAttributeName";
    private static final Logger LOGGER = LoggerFactory.getLogger(OortConfigServlet.class);
    private boolean exported;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String bayeuxServerContextAttributeName = this.getBayeuxServerContextAttributeName();
        ServletContext servletContext = config.getServletContext();
        BayeuxServer bayeux = (BayeuxServer)servletContext.getAttribute(bayeuxServerContextAttributeName);
        if (bayeux == null) {
            throw new UnavailableException("Missing " + bayeuxServerContextAttributeName + " attribute");
        }
        String url = this.provideOortURL();
        if (url == null) {
            throw new UnavailableException("Missing oort.url init parameter");
        }
        String oortContextAttributeName = this.getOortContextAttributeName();
        Oort oort = (Oort)servletContext.getAttribute(oortContextAttributeName);
        try {
            if (oort == null) {
                this.exported = true;
                oort = this.newOort(bayeux, url);
                this.configureOort(config, oort);
            }
            oort.start();
            if (this.exported) {
                servletContext.setAttribute(oortContextAttributeName, (Object)oort);
            }
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
        new Thread(new Starter(config, oort)).start();
    }

    protected String provideOortURL() {
        return this.getServletConfig().getInitParameter(OORT_URL_PARAM);
    }

    protected Oort newOort(BayeuxServer bayeux, String url) {
        return new Oort(bayeux, url);
    }

    protected void configureOort(ServletConfig config, Oort oort) throws Exception {
        String clientTransportFactories;
        String enableAckExtension;
        String secret = config.getInitParameter(OORT_SECRET_PARAM);
        if (secret != null) {
            oort.setSecret(secret);
        }
        if ((enableAckExtension = config.getInitParameter(OORT_ENABLE_ACK_EXTENSION_PARAM)) == null) {
            enableAckExtension = "true";
        }
        oort.setAckExtensionEnabled(Boolean.parseBoolean(enableAckExtension));
        String enableBinaryExtension = config.getInitParameter(OORT_ENABLE_BINARY_EXTENSION_PARAM);
        if (enableBinaryExtension == null) {
            enableBinaryExtension = "true";
        }
        oort.setBinaryExtensionEnabled(Boolean.parseBoolean(enableBinaryExtension));
        String jsonContext = config.getInitParameter(OORT_JSON_CONTEXT_PARAM);
        if (jsonContext != null) {
            Class<?> klass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(jsonContext);
            oort.setJSONContextClient((JSONContext.Client)klass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        if ((clientTransportFactories = config.getInitParameter(OORT_CLIENT_TRANSPORT_FACTORIES_PARAM)) != null) {
            ArrayList<ClientTransport.Factory> factories = new ArrayList<ClientTransport.Factory>();
            for (String className : clientTransportFactories.split(",")) {
                Class<?> klass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className.trim());
                factories.add((ClientTransport.Factory)klass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            oort.setClientTransportFactories(factories);
        }
    }

    protected abstract void configureCloud(ServletConfig var1, Oort var2) throws Exception;

    public void destroy() {
        try {
            ServletContext servletContext = this.getServletConfig().getServletContext();
            String oortContextAttributeName = this.getOortContextAttributeName();
            Oort oort = (Oort)servletContext.getAttribute(oortContextAttributeName);
            if (oort != null) {
                oort.stop();
            }
            if (this.exported) {
                servletContext.removeAttribute(oortContextAttributeName);
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private String getBayeuxServerContextAttributeName() {
        String name = this.getServletConfig().getInitParameter("bayeuxServerContextAttributeName");
        return name != null ? name : "org.cometd.bayeux";
    }

    private String getOortContextAttributeName() {
        String name = this.getServletConfig().getInitParameter(OORT_CONTEXT_ATTRIBUTE_NAME_PARAM);
        return name != null ? name : Oort.OORT_ATTRIBUTE;
    }

    private class Starter
    implements Runnable {
        private final ServletConfig config;
        private final Oort oort;
        private final OortComet oortComet;

        private Starter(ServletConfig config, Oort oort) {
            this.config = config;
            this.oort = oort;
            this.oortComet = oort.newOortComet(oort.getURL());
            this.oortComet.setOption("maxBackoff", (Object)1000L);
        }

        @Override
        public void run() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Connecting to self: {}", (Object)this.oort);
            }
            Map fields = this.oort.newOortHandshakeFields(this.oort.getURL(), null);
            this.oortComet.handshake(fields, message -> {
                Map advice = message.getAdvice();
                if (message.isSuccessful() || advice != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Connected to self: {}", (Object)this.oort);
                    }
                    this.oortComet.disconnect();
                    this.joinCloud();
                }
            });
        }

        private void joinCloud() {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Joining cloud: {}", (Object)this.oort);
                }
                OortConfigServlet.this.configureCloud(this.config, this.oort);
                String channels = this.config.getInitParameter(OortConfigServlet.OORT_CHANNELS_PARAM);
                if (channels != null) {
                    String[] patterns;
                    for (String channel : patterns = channels.split(",")) {
                        if ((channel = channel.trim()).isEmpty()) continue;
                        this.oort.observeChannel(channel);
                    }
                }
            }
            catch (Throwable x) {
                LOGGER.warn("Could not start Oort", x);
                OortConfigServlet.this.destroy();
            }
        }
    }
}

