/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort.jakarta;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import org.cometd.oort.Oort;
import org.cometd.oort.Seti;

public class SetiServlet
extends HttpServlet {
    public static final String SETI_CONTEXT_ATTRIBUTE_NAME_PARAM = "setiContextAttributeName";
    private boolean exported;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String oortContextAttributeName = this.getOortContextAttributeName();
        ServletContext servletContext = config.getServletContext();
        Oort oort = (Oort)servletContext.getAttribute(oortContextAttributeName);
        if (oort == null) {
            throw new UnavailableException("Missing " + oortContextAttributeName + " attribute");
        }
        try {
            String setiContextAttributeName = this.getSetiContextAttributeName();
            Seti seti = (Seti)servletContext.getAttribute(setiContextAttributeName);
            if (seti == null) {
                this.exported = true;
                seti = this.newSeti(oort);
            }
            seti.start();
            if (this.exported) {
                servletContext.setAttribute(setiContextAttributeName, (Object)seti);
            }
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected Seti newSeti(Oort oort) {
        return new Seti(oort);
    }

    public void destroy() {
        try {
            String setiContextAttributeName = this.getSetiContextAttributeName();
            ServletContext servletContext = this.getServletConfig().getServletContext();
            Seti seti = (Seti)servletContext.getAttribute(setiContextAttributeName);
            if (seti != null) {
                seti.stop();
            }
            if (this.exported) {
                servletContext.removeAttribute(setiContextAttributeName);
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private String getOortContextAttributeName() {
        String name = this.getServletConfig().getInitParameter("oortContextAttributeName");
        return name != null ? name : Oort.OORT_ATTRIBUTE;
    }

    private String getSetiContextAttributeName() {
        String name = this.getServletConfig().getInitParameter(SETI_CONTEXT_ATTRIBUTE_NAME_PARAM);
        return name != null ? name : Seti.SETI_ATTRIBUTE;
    }
}

