/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.jakarta;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketEndPoint
extends Endpoint
implements MessageHandler.Whole<String> {
    private final Logger _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AbstractWebSocketEndPoint _delegate;
    private volatile Session _wsSession;

    public WebSocketEndPoint(AbstractWebSocketTransport transport, BayeuxContext bayeuxContext) {
        this._delegate = new Delegate(transport, bayeuxContext);
    }

    public void onOpen(Session wsSession, EndpointConfig config) {
        this._wsSession = wsSession;
        wsSession.addMessageHandler((MessageHandler)this);
    }

    public void onMessage(String data) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("WebSocket Text message on {}", (Object)this);
        }
        try {
            try {
                Promise.Completable completable = new Promise.Completable();
                this._delegate.onMessage(data, (Promise)completable);
                completable.get();
            }
            catch (ExecutionException x) {
                throw x.getCause();
            }
        }
        catch (Throwable failure) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("", failure);
            }
            this._delegate.close(1011, failure.toString());
        }
    }

    public void onClose(Session wsSession, CloseReason closeReason) {
        this._delegate.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    public void onError(Session wsSession, Throwable failure) {
        this._delegate.onError(failure);
    }

    protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
    }

    public String toString() {
        return String.format("%s@%x[%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this._delegate);
    }

    private class Delegate
    extends AbstractWebSocketEndPoint {
        public Delegate(AbstractWebSocketTransport transport, BayeuxContext bayeuxContext) {
            super(transport, bayeuxContext);
        }

        protected void send(ServerSession session, String data, Promise<Void> promise) {
            if (WebSocketEndPoint.this._logger.isDebugEnabled()) {
                WebSocketEndPoint.this._logger.debug("Sending {} on {}", (Object)data, (Object)this);
            }
            WebSocketEndPoint.this._wsSession.getAsyncRemote().sendText(data, result -> {
                Throwable failure = result.getException();
                if (failure == null) {
                    promise.succeed(null);
                } else {
                    promise.fail(failure);
                }
            });
        }

        public void close(int code, String reason) {
            try {
                reason = reason.substring(0, Math.min(reason.length(), 30));
                if (WebSocketEndPoint.this._logger.isDebugEnabled()) {
                    WebSocketEndPoint.this._logger.debug("Closing {}/{} on {}", new Object[]{code, reason, this});
                }
                WebSocketEndPoint.this._wsSession.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
            }
            catch (Throwable x) {
                WebSocketEndPoint.this._logger.trace("Could not close WebSocket session on {}", (Object)this, (Object)x);
            }
        }

        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
            WebSocketEndPoint.this.writeComplete(context, messages);
        }

        public String toString() {
            return String.format("%s[%s]", super.toString(), WebSocketEndPoint.this._wsSession);
        }
    }
}

