/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ThreadContext
implements Map<String, Object> {
    private static ThreadLocal<ThreadContext> THREAD_LOCAL = new ThreadLocal();
    private final Map<String, Object> contextMap = new ConcurrentHashMap<String, Object>();
    private Map<String, String> mdcMap;
    private int refs = 1;
    private List<Consumer<ThreadContext>> finalizers = new ArrayList<Consumer<ThreadContext>>();

    public static ThreadContext getContext(boolean create) {
        ThreadContext threadContext = THREAD_LOCAL.get();
        if (threadContext == null && create) {
            threadContext = new ThreadContext();
            threadContext.mdcMap = MDC.getCopyOfContextMap();
            THREAD_LOCAL.set(threadContext);
        }
        return threadContext;
    }

    public static ThreadContext setContext(ThreadContext ctx) {
        ThreadContext oldCtx = ThreadContext.swapContext(ctx);
        if (ctx != null && ctx.mdcMap != null) {
            MDC.setContextMap(ctx.mdcMap);
        }
        return oldCtx;
    }

    private static ThreadContext swapContext(ThreadContext ctx) {
        ThreadContext oldCtx = THREAD_LOCAL.get();
        if (oldCtx != null) {
            Logger logger = LoggerFactory.getLogger(ThreadContext.class);
            --oldCtx.refs;
            logger.trace("context refs: {}", (Object)oldCtx.refs);
            oldCtx.runFinalizersIfDone();
        }
        THREAD_LOCAL.set(ctx);
        if (ctx != null) {
            ++ctx.refs;
        }
        return oldCtx;
    }

    public synchronized void registerFinalizer(Consumer<ThreadContext> finalizer) {
        if (!this.finalizers.contains(finalizer)) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.debug("Registering finalizer: {} on ThreadContext: {}", finalizer, (Object)this);
            this.finalizers.add(finalizer);
        }
    }

    private synchronized void runFinalizersIfDone() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (this.refs < 1 && this.finalizers != null) {
            logger.debug("Running finalizers for ThreadContext: {}", (Object)this);
            this.finalizers.forEach((? super T c) -> {
                if (c != null) {
                    logger.debug("Running finalizer: {} for ThreadContext: {}", c, (Object)this);
                    try {
                        c.accept(this);
                    }
                    catch (Throwable t) {
                        logger.error("Caught error while running finalizer: " + c + " on ThreadContext: " + this, t);
                    }
                    logger.trace("Finalizer: {} done for ThreadContext: {}", c, (Object)this);
                }
            });
        }
    }

    public static void clearContext() {
        ThreadContext.swapContext(null);
        MDC.clear();
    }

    private ThreadContext() {
    }

    @Override
    public int size() {
        return this.contextMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contextMap.isEmpty();
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.contextMap.putAll(map);
    }

    @Override
    public Collection<Object> values() {
        return this.contextMap.values();
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.contextMap.merge(key, value, remappingFunction);
    }

    @Override
    public Set<String> keySet() {
        return this.contextMap.keySet();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.contextMap.forEach(action);
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.contextMap.computeIfPresent(key, remappingFunction);
    }

    @Override
    public void clear() {
        this.contextMap.clear();
    }

    @Override
    public boolean containsValue(Object o) {
        return this.contextMap.containsValue(o);
    }

    @Override
    public Object put(String s, Object o) {
        return this.contextMap.put(s, o);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        this.contextMap.replaceAll(function);
    }

    @Override
    public Object get(Object o) {
        return this.contextMap.get(o);
    }

    @Override
    public boolean containsKey(Object o) {
        return this.contextMap.containsKey(o);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.contextMap.entrySet();
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        return this.contextMap.replace(key, oldValue, newValue);
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        return this.contextMap.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.contextMap.compute(key, remappingFunction);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        return this.contextMap.putIfAbsent(key, value);
    }

    @Override
    public Object remove(Object o) {
        return this.contextMap.remove(o);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.contextMap.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.contextMap.remove(key, value);
    }

    @Override
    public Object replace(String key, Object value) {
        return this.contextMap.replace(key, value);
    }
}

