/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.model;

import java.util.Objects;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.util.PathUtils;

public class ConcreteResource
implements Resource {
    final Location location;
    final String path;

    public ConcreteResource(Location location, String ... path) {
        this.path = PathUtils.normalize(path);
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return String.format("Resource [location=%s, path=%s]", this.location, this.getPath());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConcreteResource)) {
            return false;
        }
        ConcreteResource other = (ConcreteResource)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        String path = this.getPath();
        String otherPath = other.getPath();
        if (path == null) {
            return otherPath == null;
        }
        return path.equals(otherPath);
    }

    @Override
    public boolean allowsDownloading() {
        return this.location.allowsDownloading();
    }

    @Override
    public boolean allowsPublishing() {
        return this.location.allowsPublishing();
    }

    @Override
    public boolean allowsStoring() {
        return this.location.allowsStoring();
    }

    @Override
    public boolean allowsSnapshots() {
        return this.location.allowsSnapshots();
    }

    @Override
    public boolean allowsReleases() {
        return this.location.allowsReleases();
    }

    @Override
    public boolean allowsDeletion() {
        return this.location.allowsDeletion();
    }

    public String getLocationUri() {
        return this.location.getUri();
    }

    public String getLocationName() {
        return this.location.getName();
    }

    public boolean isRoot() {
        return Objects.equals(this.path, "/");
    }

    public ConcreteResource getParent() {
        if (this.isRoot()) {
            return null;
        }
        return new ConcreteResource(this.location, PathUtils.parentPath(this.path));
    }

    public ConcreteResource getChild(String file) {
        return new ConcreteResource(this.location, PathUtils.normalize(this.path, file));
    }

    public String getPath() {
        return this.path;
    }
}

