/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.filearc.internal.AbstractZipOperation;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.spi.transport.ExistenceJob;

public class ZipExistence
extends AbstractZipOperation
implements ExistenceJob {
    private TransferException error;

    public ZipExistence(ConcreteResource resource) {
        super(resource);
    }

    public TransferException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean call() {
        File src = this.getZipFile();
        if (src.isDirectory()) {
            return null;
        }
        ZipFile zf = null;
        try {
            zf = this.isJarOperation() ? new JarFile(src) : new ZipFile(src);
            String path = this.getFullPath();
            this.logger.debug("Looking for entry: {}", (Object)path);
            boolean found = false;
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                String name = zipEntry.getName();
                this.logger.debug("Checking entry: {}", (Object)name);
                if (!name.equals(path)) continue;
                found = true;
                break;
            }
            Boolean bl = found;
            return bl;
        }
        catch (IOException e) {
            this.error = new TransferException("Failed to get listing for: %s:%s to: %s. Reason: %s", (Throwable)e, new Object[]{this.getLocation(), this.getPath(), e.getMessage()});
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

