/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.filearc.internal.AbstractZipOperation;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.transport.ListingJob;

public class ZipListing
extends AbstractZipOperation
implements ListingJob {
    private TransferException error;

    public ZipListing(ConcreteResource resource, Transfer target) {
        super(resource);
        this.transfer = target;
    }

    public TransferException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListingResult call() {
        File src = this.getZipFile();
        if (src.isDirectory()) {
            return null;
        }
        boolean isJar = this.isJarOperation();
        TreeSet<String> filenames = new TreeSet<String>();
        ZipFile zf = null;
        try {
            zf = isJar ? new JarFile(src) : new ZipFile(src);
            String path = this.getFullPath();
            int pathLen = path.length();
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                String name = zipEntry.getName();
                if (!name.startsWith(path) || !(name = name.substring(pathLen)).startsWith("/") || name.length() <= 1 || (name = name.substring(1)).indexOf("/") >= 0) continue;
                filenames.add(name);
            }
        }
        catch (IOException e) {
            this.error = new TransferException("Failed to get listing for: %s to: %s. Reason: %s", (Throwable)e, new Object[]{this.resource, e.getMessage()});
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!filenames.isEmpty()) {
            return new ListingResult(this.resource, filenames.toArray(new String[filenames.size()]));
        }
        return null;
    }
}

