/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.commonjava.maven.galley.GalleyException;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferLocationException;
import org.commonjava.maven.galley.TransferTimeoutException;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.util.TransferResponseUtils;
import org.commonjava.maven.galley.transport.htcli.model.HttpExchangeMetadata;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.commonjava.maven.galley.transport.htcli.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpJob {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String url;
    protected final HttpLocation location;
    protected final Http http;
    protected TransferException error;
    protected HttpUriRequest request;
    protected CloseableHttpClient client;
    protected CloseableHttpResponse response;
    private final Collection<Integer> successStatuses;
    protected boolean success;

    protected AbstractHttpJob(String url, HttpLocation location, Http http, Integer ... successStatuses) {
        this.url = url;
        this.location = location;
        this.http = http;
        this.successStatuses = successStatuses.length < 1 ? Collections.singleton(200) : Arrays.asList(successStatuses);
    }

    public TransferException getError() {
        return this.error;
    }

    public long getTransferSize() {
        return this.response == null ? -1L : HttpUtil.getContentLength(this.response);
    }

    protected boolean executeHttp() throws TransferException {
        try {
            this.client = this.http.createClient(this.location);
            this.response = this.client.execute(this.request, (HttpContext)this.http.createContext(this.location));
            StatusLine line = this.response.getStatusLine();
            int sc = line.getStatusCode();
            this.logger.trace("{} {} : {}", new Object[]{this.request.getMethod(), line, this.url});
            if (sc > 399 && sc != 404 && sc != 408 && sc != 502 && sc != 503 && sc != 504) {
                throw new TransferLocationException((Location)this.location, "Server misconfigured or not responding normally: '%s'", new Object[]{line});
            }
            if (!this.successStatuses.contains(sc)) {
                this.logger.trace("Detected failure respon se: " + sc);
                this.success = TransferResponseUtils.handleUnsuccessfulResponse(this.request, this.response, this.location, this.url);
                this.logger.trace("Returning non-error failure response for code: " + sc);
                boolean bl = false;
                return bl;
            }
        }
        catch (SocketTimeoutException | NoHttpResponseException | ConnectTimeoutException e) {
            throw new TransferTimeoutException((Location)this.location, this.url, "Repository remote request failed for: {}. Reason: {}", e, new Object[]{this.url, e.getMessage()});
        }
        catch (IOException e) {
            throw new TransferLocationException((Location)this.location, "Repository remote request failed for: {}. Reason: {}", (Throwable)e, new Object[]{this.url, e.getMessage()});
        }
        catch (TransferLocationException e) {
            throw e;
        }
        catch (GalleyException e) {
            throw new TransferException("Repository remote request failed for: {}. Reason: {}", (Throwable)e, new Object[]{this.url, e.getMessage()});
        }
        finally {
            String method = this.request.getMethod();
            if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
                Transfer target = this.getTransfer();
                ObjectMapper mapper = this.getMetadataObjectMapper();
                if (target != null && mapper != null) {
                    this.writeMetadata(target, mapper);
                }
            }
        }
        return true;
    }

    protected Transfer getTransfer() {
        return null;
    }

    protected ObjectMapper getMetadataObjectMapper() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetadata(Transfer target, final ObjectMapper mapper) {
        if (target == null || this.request == null || this.response == null) {
            this.logger.trace("Cannot write HTTP exchange metadata. Request: {}. Response: {}. Transfer: {}", new Object[]{this.request, this.response, target});
            return;
        }
        this.logger.trace("Writing HTTP exchange metadata. Request: {}. Response: {}", (Object)this.request, (Object)this.response);
        Transfer metaTxfr = target.getSiblingMeta(".http-metadata.json");
        if (metaTxfr == null) {
            if (target.isDirectory()) {
                this.logger.trace("DIRECTORY. Using HTTP exchange metadata file INSIDE directory called: {}", (Object)".http-metadata.json");
                metaTxfr = target.getChild(".http-metadata.json");
            } else {
                this.logger.trace("SKIP: Cannot retrieve HTTP exchange metadata Transfer instance for: {}", (Object)target);
                return;
            }
        }
        final HttpExchangeMetadata metadata = new HttpExchangeMetadata((HttpRequest)this.request, (HttpResponse)this.response);
        OutputStream out = null;
        try {
            final Transfer finalMeta = metaTxfr;
            out = metaTxfr.openOutputStream(TransferOperation.GENERATE, false);
            this.logger.trace("Writing HTTP exchange metadata:\n\n{}\n\n", new Object(){

                public String toString() {
                    try {
                        return mapper.writeValueAsString((Object)metadata);
                    }
                    catch (JsonProcessingException e) {
                        AbstractHttpJob.this.logger.warn(String.format("Failed to write HTTP exchange metadata: %s. Reason: %s", finalMeta, e.getMessage()), (Throwable)e);
                        return "ERROR RENDERING METADATA";
                    }
                }
            });
            out.write(mapper.writeValueAsBytes((Object)metadata));
        }
        catch (IOException e) {
            block9: {
                try {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace(String.format("Failed to write metadata for HTTP exchange to: %s. Reason: %s", metaTxfr, e.getMessage()), (Throwable)e);
                        break block9;
                    }
                    this.logger.warn("Failed to write metadata for HTTP exchange to: {}. Reason: {}", (Object)metaTxfr, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    protected void cleanup() {
        this.http.cleanup(this.client, this.request, this.response);
        this.client = null;
        this.request = null;
        this.response = null;
    }
}

