/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.execroot;

import java.io.File;
import java.util.List;
import java.util.Stack;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.plugins.execroot.AbstractDirectoryGoal;
import org.commonjava.maven.plugins.execroot.ProjectRef;

public class DirectoryOfGoal
extends AbstractDirectoryGoal
implements Mojo,
ContextEnabled {
    protected static final String DIR_OF_CONTEXT_KEY = "directories.directoryOf-";
    private ProjectRef project;
    protected List<MavenProject> projects;

    protected File findDirectory() throws MojoExecutionException {
        File dir = null;
        Stack<MavenProject> toCheck = new Stack<MavenProject>();
        toCheck.addAll(this.projects);
        while (!toCheck.isEmpty()) {
            MavenProject p = (MavenProject)toCheck.pop();
            if (this.project.matches(p)) {
                dir = p.getBasedir();
                break;
            }
            if (p.getParent() == null) continue;
            toCheck.add(p.getParent());
        }
        if (dir == null) {
            throw new MojoExecutionException("Cannot find directory for project: " + this.project);
        }
        return dir;
    }

    protected String getContextKey() {
        return DIR_OF_CONTEXT_KEY + this.project;
    }

    protected String getLogLabel() {
        return "Directory of " + this.project;
    }
}

