/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet.term.processor;

import java.io.Flushable;
import java.io.IOException;
import java.util.logging.Level;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.telnet.term.TermEvent;
import org.crsh.telnet.term.processor.Processor;
import org.crsh.telnet.term.processor.Status;
import org.crsh.text.Chunk;
import org.crsh.text.Text;
import org.crsh.util.Utils;

class ProcessContext
implements ShellProcessContext,
Runnable {
    final Processor processor;
    final ShellProcess process;

    ProcessContext(Processor processor, ShellProcess process) {
        this.process = process;
        this.processor = processor;
    }

    public boolean takeAlternateBuffer() throws IOException {
        return this.processor.term.takeAlternateBuffer();
    }

    public boolean releaseAlternateBuffer() throws IOException {
        return this.processor.term.releaseAlternateBuffer();
    }

    @Override
    public void run() {
        this.process.execute((ShellProcessContext)this);
    }

    public int getWidth() {
        return this.processor.term.getWidth();
    }

    public int getHeight() {
        return this.processor.term.getHeight();
    }

    public String getProperty(String name) {
        return this.processor.term.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String msg, boolean echo) {
        try {
            this.processor.term.write((Chunk)Text.create((CharSequence)msg));
            this.processor.term.flush();
        }
        catch (IOException e) {
            return null;
        }
        boolean done = false;
        while (true) {
            Object object = this.processor.lock;
            synchronized (object) {
                switch (this.processor.status) {
                    case CLOSED: 
                    case CANCELLING: {
                        return null;
                    }
                    case PROCESSING: {
                        TermEvent event;
                        if (this.processor.queue.size() <= 0 || !((event = this.processor.queue.removeFirst()) instanceof TermEvent.ReadLine)) break;
                        return ((Object)((TermEvent.ReadLine)event).getLine()).toString();
                    }
                    default: {
                        throw new AssertionError((Object)("Does not make sense " + (Object)((Object)this.processor.status)));
                    }
                }
            }
            if (done) {
                return null;
            }
            done = true;
            this.processor.waitingEvent = true;
            try {
                this.processor.term.setEcho(echo);
                this.processor.readTerm();
                this.processor.term.write((Chunk)Text.create((CharSequence)"\r\n"));
                continue;
            }
            catch (IOException e) {
                this.processor.log.log(Level.SEVERE, "Error when readline line");
                continue;
            }
            finally {
                this.processor.waitingEvent = false;
                this.processor.term.setEcho(true);
                continue;
            }
            break;
        }
    }

    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    public void write(Chunk chunk) throws IOException {
        this.provide(chunk);
    }

    public void provide(Chunk element) throws IOException {
        this.processor.term.write(element);
    }

    public void flush() throws IOException {
        this.processor.term.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ShellResponse response) {
        Status status;
        ProcessContext context;
        Runnable runnable;
        Object object = this.processor.lock;
        synchronized (object) {
            this.processor.current = null;
            switch (this.processor.status) {
                case PROCESSING: {
                    if (response instanceof ShellResponse.Close) {
                        runnable = this.processor.CLOSE_TASK;
                        this.processor.status = Status.CLOSED;
                        break;
                    }
                    if (response instanceof ShellResponse.Cancelled) {
                        runnable = Processor.NOOP;
                        this.processor.status = Status.AVAILABLE;
                        break;
                    }
                    final String message = response.getMessage();
                    runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ProcessContext.this.processor.provide((Chunk)Text.create((CharSequence)message));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            finally {
                                Utils.flush((Flushable)((Object)ProcessContext.this.processor.term));
                            }
                        }
                    };
                    this.processor.status = Status.AVAILABLE;
                    break;
                }
                case CANCELLING: {
                    runnable = Processor.NOOP;
                    this.processor.status = Status.AVAILABLE;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Does not make sense " + (Object)((Object)this.processor.status)));
                }
            }
            context = this.processor.peekProcess();
            status = this.processor.status;
        }
        runnable.run();
        if (context != null) {
            context.run();
        } else if (status == Status.AVAILABLE) {
            this.processor.writePromptFlush();
        }
    }
}

