/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.ssh.term.CRaSHCommandFactory;
import org.crsh.ssh.term.scp.SCPCommandFactory;
import org.crsh.ssh.term.subsystem.SubsystemFactoryPlugin;
import org.crsh.term.TermLifeCycle;
import org.crsh.term.spi.TermIOHandler;

public class SSHLifeCycle
extends TermLifeCycle {
    public static final Session.AttributeKey<String> USERNAME = new Session.AttributeKey();
    public static final Session.AttributeKey<String> PASSWORD = new Session.AttributeKey();
    private final Logger log = Logger.getLogger(SSHLifeCycle.class.getName());
    private SshServer server;
    private int port;
    private int idleTimeout;
    private int authTimeout;
    private KeyPairProvider keyPairProvider;
    private final ArrayList<AuthenticationPlugin> authenticationPlugins;
    private Integer localPort;

    public SSHLifeCycle(PluginContext context, ArrayList<AuthenticationPlugin> authenticationPlugins) {
        super(context);
        this.authenticationPlugins = authenticationPlugins;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public void setAuthTimeout(int authTimeout) {
        this.authTimeout = authTimeout;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.keyPairProvider;
    }

    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
    }

    protected void doInit() {
        try {
            TermIOHandler handler = this.getHandler();
            SshServer server = SshServer.setUpDefaultServer();
            server.setPort(this.port);
            if (this.idleTimeout > 0) {
                server.getProperties().put("idle-timeout", String.valueOf(this.idleTimeout));
            }
            if (this.authTimeout > 0) {
                server.getProperties().put("auth-timeout", String.valueOf(this.authTimeout));
            }
            server.setShellFactory(new CRaSHCommandFactory(handler));
            server.setCommandFactory(new SCPCommandFactory(this.getContext()));
            server.setKeyPairProvider(this.keyPairProvider);
            ArrayList<NamedFactory<Command>> namedFactoryList = new ArrayList<NamedFactory<Command>>(0);
            for (SubsystemFactoryPlugin plugin : this.getContext().getPlugins(SubsystemFactoryPlugin.class)) {
                namedFactoryList.add(plugin.getFactory());
            }
            server.setSubsystemFactories(namedFactoryList);
            for (AuthenticationPlugin authenticationPlugin : this.authenticationPlugins) {
                if (server.getPasswordAuthenticator() == null && authenticationPlugin.getCredentialType().equals(String.class)) {
                    server.setPasswordAuthenticator(new PasswordAuthenticator(){

                        @Override
                        public boolean authenticate(String _username, String _password, ServerSession session) {
                            if (SSHLifeCycle.this.genericAuthenticate(String.class, _username, _password)) {
                                session.setAttribute(USERNAME, _username);
                                session.setAttribute(PASSWORD, _password);
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (server.getPublickeyAuthenticator() != null || !authenticationPlugin.getCredentialType().equals(PublicKey.class)) continue;
                server.setPublickeyAuthenticator(new PublickeyAuthenticator(){

                    @Override
                    public boolean authenticate(String username, PublicKey key, ServerSession session) {
                        return SSHLifeCycle.this.genericAuthenticate(PublicKey.class, username, key);
                    }
                });
            }
            this.log.log(Level.INFO, "About to start CRaSSHD");
            server.start();
            this.localPort = server.getPort();
            this.log.log(Level.INFO, "CRaSSHD started on port " + this.localPort);
            this.server = server;
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "Could not start CRaSSHD", e);
        }
    }

    protected void doDestroy() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                this.log.log(Level.FINE, "Got an interruption when stopping server", e);
            }
        }
    }

    private <T> boolean genericAuthenticate(Class<T> type, String username, T credential) {
        for (AuthenticationPlugin authenticationPlugin : this.authenticationPlugins) {
            if (!authenticationPlugin.getCredentialType().equals(type)) continue;
            try {
                this.log.log(Level.FINE, "Using authentication plugin " + authenticationPlugin + " to authenticate user " + username);
                AuthenticationPlugin authPlugin = authenticationPlugin;
                if (!authPlugin.authenticate(username, credential)) continue;
                return true;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Exception authenticating user " + username + " in authentication plugin: " + authenticationPlugin, e);
            }
        }
        return false;
    }
}

