/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nio2Acceptor
extends Nio2Service
implements IoAcceptor {
    private final Map<SocketAddress, AsynchronousServerSocketChannel> channels = new ConcurrentHashMap<SocketAddress, AsynchronousServerSocketChannel>();
    private final Map<SocketAddress, AsynchronousServerSocketChannel> unbound = new ConcurrentHashMap<SocketAddress, AsynchronousServerSocketChannel>();
    private int backlog = 50;

    public Nio2Acceptor(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        super(manager, handler, group);
    }

    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        for (SocketAddress socketAddress : addresses) {
            this.logger.debug("Binding Nio2Acceptor to address {}", (Object)socketAddress);
            AsynchronousServerSocketChannel socket = AsynchronousServerSocketChannel.open(this.group);
            socket.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
            socket.bind(socketAddress, this.backlog);
            SocketAddress local = socket.getLocalAddress();
            this.channels.put(local, socket);
            socket.accept(local, new AcceptCompletionHandler(socket));
        }
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.bind(Collections.singleton(address));
    }

    @Override
    public void unbind() {
        this.logger.debug("Unbinding");
        this.unbind(this.getBoundAddresses());
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        for (SocketAddress socketAddress : addresses) {
            AsynchronousServerSocketChannel channel = this.channels.remove(socketAddress);
            if (channel == null) continue;
            this.unbound.put(socketAddress, channel);
        }
    }

    @Override
    public void unbind(SocketAddress address) {
        this.unbind(Collections.singleton(address));
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.channels.keySet());
    }

    @Override
    public CloseFuture close(boolean immediately) {
        this.unbind();
        return super.close(immediately);
    }

    @Override
    public void doDispose() {
        for (SocketAddress address : this.channels.keySet()) {
            try {
                this.channels.get(address).close();
            }
            catch (IOException e) {
                this.logger.debug("Exception caught while closing channel", e);
            }
        }
        super.doDispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AcceptCompletionHandler
    implements CompletionHandler<AsynchronousSocketChannel, SocketAddress> {
        private final AsynchronousServerSocketChannel socket;

        AcceptCompletionHandler(AsynchronousServerSocketChannel socket) {
            this.socket = socket;
        }

        @Override
        public void completed(AsynchronousSocketChannel result, SocketAddress address) {
            if (!Nio2Acceptor.this.channels.containsKey(address)) {
                try {
                    result.close();
                }
                catch (IOException e) {
                    Nio2Acceptor.this.logger.debug("Ignoring error closing accepted connection on unbound socket", e);
                }
                this.acceptorStopped(address);
                return;
            }
            try {
                Nio2Session session = new Nio2Session(Nio2Acceptor.this, Nio2Acceptor.this.handler, result);
                Nio2Acceptor.this.handler.sessionCreated(session);
                Nio2Acceptor.this.sessions.put(session.getId(), session);
                session.startReading();
                this.socket.accept(address, this);
            }
            catch (Throwable exc) {
                this.failed(exc, address);
            }
        }

        @Override
        public void failed(Throwable exc, SocketAddress address) {
            if (!Nio2Acceptor.this.channels.containsKey(address)) {
                this.acceptorStopped(address);
            } else if (!Nio2Acceptor.this.disposing.get()) {
                Nio2Acceptor.this.logger.warn("Caught exception while accepting incoming connection", exc);
            }
        }

        protected void acceptorStopped(SocketAddress address) {
        }
    }
}

