/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.sort.CollectionOfModulesToSort;
import org.apache.ivy.core.sort.ModuleInSort;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.plugins.circular.CircularDependencyException;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class ModuleDescriptorSorter {
    private final CollectionOfModulesToSort moduleDescriptors;
    private final List sorted = new LinkedList();
    private final CircularDependencyStrategy circularDepStrategy;

    public ModuleDescriptorSorter(Collection modulesDescriptorsToSort, VersionMatcher matcher, NonMatchingVersionReporter nonMatchingVersionReporter, CircularDependencyStrategy circularDepStrategy) {
        this.circularDepStrategy = circularDepStrategy;
        this.moduleDescriptors = new CollectionOfModulesToSort(modulesDescriptorsToSort, matcher, nonMatchingVersionReporter);
    }

    public List sortModuleDescriptors() throws CircularDependencyException {
        Message.debug("Nbr of module to sort : " + this.moduleDescriptors.size());
        Iterator moduleDescriptorsIterator = this.moduleDescriptors.iterator();
        while (moduleDescriptorsIterator.hasNext()) {
            ModuleInSort next = (ModuleInSort)moduleDescriptorsIterator.next();
            this.sortModuleDescriptorsHelp(next, next);
        }
        return this.sorted;
    }

    private void sortModuleDescriptorsHelp(ModuleInSort current, ModuleInSort caller) throws CircularDependencyException {
        if (current.isProcessed()) {
            return;
        }
        if (current.checkLoop(caller, this.circularDepStrategy)) {
            return;
        }
        DependencyDescriptor[] descriptors = current.getDependencies();
        Message.debug("Sort dependencies of : " + current.toString() + " / Number of dependencies = " + descriptors.length);
        current.setCaller(caller);
        for (int i = 0; i < descriptors.length; ++i) {
            ModuleInSort child = this.moduleDescriptors.getModuleDescriptorDependency(descriptors[i]);
            if (child == null) continue;
            this.sortModuleDescriptorsHelp(child, current);
        }
        current.endOfCall();
        Message.debug("Sort done for : " + current.toString());
        current.addToSortedListIfRequired(this.sorted);
    }
}

