/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import junit.framework.TestCase;
import org.crsh.cli.Command;
import org.crsh.cli.Man;
import org.crsh.cli.Option;
import org.crsh.cli.Usage;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.lang.CommandFactory;

public class DescriptionTestCase
extends TestCase {
    public void testNoDescription() throws Exception {
        class A {
            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        DescriptionTestCase.assertEquals((String)"", (String)c.getUsage());
        DescriptionTestCase.assertEquals((Object)new Description(), (Object)c.getDescription());
    }

    public void testClassDescription() throws Exception {
        @Usage(value="class_usage")
        @Man(value="class_man")
        class A {
            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        DescriptionTestCase.assertEquals((String)"class_usage", (String)c.getUsage());
        DescriptionTestCase.assertEquals((String)"class_usage", (String)c.getDescription().getUsage());
        DescriptionTestCase.assertEquals((String)"class_man", (String)c.getDescription().getMan());
    }

    public void testMethodDescription() throws Exception {
        class A {
            A() {
            }

            @Usage(value="method_usage")
            @Man(value="method_man")
            @Command
            void m() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandDescriptor m = c.getSubordinate("m");
        DescriptionTestCase.assertEquals((String)"method_usage", (String)m.getUsage());
        DescriptionTestCase.assertEquals((String)"method_usage", (String)m.getDescription().getUsage());
        DescriptionTestCase.assertEquals((String)"method_man", (String)m.getDescription().getMan());
    }

    public void testParameterDescription() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Usage(value="option_usage") @Man(value="option_man") @Option(names={"a"}) String s) {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandDescriptor m = c.getSubordinate("m");
        OptionDescriptor a = m.getOption("-a");
        DescriptionTestCase.assertEquals((String)"option_usage", (String)a.getUsage());
        DescriptionTestCase.assertEquals((String)"option_usage", (String)a.getDescription().getUsage());
        DescriptionTestCase.assertEquals((String)"option_man", (String)a.getDescription().getMan());
    }

    public void testParameterMetaDescription1() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Foo String s) {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandDescriptor m = c.getSubordinate("m");
        OptionDescriptor a = m.getOption("-a");
        DescriptionTestCase.assertEquals((String)"foo_usage", (String)a.getUsage());
        DescriptionTestCase.assertEquals((String)"foo_usage", (String)a.getDescription().getUsage());
        DescriptionTestCase.assertEquals((String)"foo_man", (String)a.getDescription().getMan());
    }

    public void testParameterMetaDescription2() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Bar String s) {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandDescriptor m = c.getSubordinate("m");
        OptionDescriptor a = m.getOption("-a");
        DescriptionTestCase.assertEquals((String)"", (String)a.getUsage());
        DescriptionTestCase.assertEquals((Object)new Description(), (Object)a.getDescription());
    }

    public void testParameterMetaDescription3() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Usage(value="option_usage") @Foo String s) {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandDescriptor m = c.getSubordinate("m");
        OptionDescriptor a = m.getOption("-a");
        DescriptionTestCase.assertEquals((String)"option_usage", (String)a.getUsage());
        DescriptionTestCase.assertEquals((String)"option_usage", (String)a.getDescription().getUsage());
        DescriptionTestCase.assertEquals((String)"foo_man", (String)a.getDescription().getMan());
    }

    @Option(names={"a"})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Bar {
    }

    @Option(names={"a"})
    @Usage(value="foo_usage")
    @Man(value="foo_man")
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Foo {
    }
}

