/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.bootstrap;

import junit.framework.TestCase;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.Help;
import org.crsh.cli.impl.descriptor.HelpDescriptor;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.invocation.ParameterMatch;
import org.crsh.cli.impl.lang.CommandFactory;

public class BootstrapTestCase
extends TestCase {
    public void testOption() throws Exception {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        HelpDescriptor helpDesc = new HelpDescriptor(desc);
        OptionDescriptor optionDesc = helpDesc.getOption("-h");
        BootstrapTestCase.assertNotNull((Object)optionDesc);
        OptionDescriptor foo = helpDesc.getOption("-f");
        BootstrapTestCase.assertNotNull((Object)foo);
        HelpDescriptor bar = helpDesc.getSubordinate("bar");
        OptionDescriptor barHelp = bar.getOption("-h");
        BootstrapTestCase.assertNull((Object)barHelp);
        InvocationMatcher matcher = helpDesc.invoker("main");
        InvocationMatch match = matcher.match("--help");
        ParameterMatch helpMatch = match.getParameter((ParameterDescriptor)optionDesc);
        BootstrapTestCase.assertNotNull((Object)helpMatch);
        CommandInvoker invoker = match.getInvoker();
        Help help = (Help)invoker.invoke((Object)new A());
        BootstrapTestCase.assertNotNull((Object)help);
        BootstrapTestCase.assertSame((Object)desc, (Object)help.getDescriptor());
        match = matcher.match("");
        invoker = match.getInvoker();
        invoker.invoke((Object)new A());
        match = matcher.match("-f foo_value bar");
        invoker = match.getInvoker();
        BootstrapTestCase.assertEquals((Object)"invoked:foo_value", (Object)invoker.invoke((Object)new A()));
    }

    public void testMain() {
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(B.class);
        HelpDescriptor helpDesc = new HelpDescriptor(desc);
        OptionDescriptor optionDesc = helpDesc.getOption("-h");
        BootstrapTestCase.assertNotNull((Object)optionDesc);
        InvocationMatcher matcher = helpDesc.invoker("main");
        InvocationMatch match = matcher.match("--help");
        ParameterMatch helpMatch = match.getParameter((ParameterDescriptor)optionDesc);
        BootstrapTestCase.assertNull((Object)helpMatch);
        InvocationMatch ownerMatch = match.owner();
        helpMatch = ownerMatch.getParameter((ParameterDescriptor)optionDesc);
        BootstrapTestCase.assertNotNull((Object)helpMatch);
        CommandInvoker invoker = match.getInvoker();
        Help help = (Help)invoker.invoke((Object)new B());
        BootstrapTestCase.assertNotNull((Object)help);
        CommandDescriptor mainDescriptor = help.getDescriptor();
        BootstrapTestCase.assertEquals((String)"main", (String)mainDescriptor.getName());
        BootstrapTestCase.assertSame((Object)desc, (Object)mainDescriptor.getOwner());
    }

    public static class B {
        @Command
        public void main() throws Exception {
            throw new UnsupportedOperationException("Should not invoked");
        }
    }

    public class A {
        @Option(names={"f", "foo"})
        String foo;

        @Command
        public String bar() {
            return "invoked:" + this.foo;
        }
    }
}

