/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.cli.Argument;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.impl.LiteralValue;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.invocation.ArgumentMatch;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.invocation.OptionMatch;
import org.crsh.cli.impl.lang.CommandFactory;

public class Parser2TestCase
extends TestCase {
    public void testMixed() throws Exception {
        class A {
            @Option(names={"o"})
            String o;
            @Option(names={"p"})
            boolean p;
            @Argument
            String a;
            @Argument
            List<String> b;

            A() {
            }
        }
        new Test(A.class, "-o foo bar").assertOption("o", "foo").assertArgument(7, 10, "bar").assertDone();
        new Test(A.class, "-o foo -p bar").assertOption("o", "foo").assertOption("p", new String[0]).assertArgument(10, 13, "bar").assertDone();
    }

    public void testArgument() throws Exception {
        class A {
            @Argument
            String a;

            A() {
            }
        }
        new Test(A.class, "foo").assertArgument(0, 3, "foo").assertDone();
        new Test(A.class, "foo bar").assertArgument(0, 3, "foo").assertDone("bar");
        class B {
            @Argument
            List<String> a;

            B() {
            }
        }
        new Test(B.class, "foo").assertArgument(0, 3, "foo").assertDone();
        new Test(B.class, "foo bar").assertArgument(0, 7, "foo", "bar").assertDone();
        class C {
            @Argument
            String a;
            @Argument
            List<String> b;

            C() {
            }
        }
        new Test(C.class, "foo").assertArgument(0, 3, "foo").assertDone();
        new Test(C.class, "foo bar").assertArgument(0, 3, "foo").assertArgument(4, 7, "bar").assertDone();
        new Test(C.class, "foo bar juu").assertArgument(0, 3, "foo").assertArgument(4, 11, "bar", "juu").assertDone();
        class D {
            @Argument
            List<String> a;
            @Argument
            String b;

            D() {
            }
        }
        new Test(D.class, "").assertDone();
        new Test(D.class, "foo").assertArgument(0, 3, "foo").assertDone();
        new Test(D.class, "foo bar").assertArgument(0, 3, "foo").assertArgument(4, 7, "bar").assertDone();
        new Test(D.class, "foo bar juu").assertArgument(0, 7, "foo", "bar").assertArgument(8, 11, "juu").assertDone();
        class E {
            @Argument
            String a;
            @Argument
            List<String> b;
            @Argument
            String c;

            E() {
            }
        }
        new Test(E.class, "").assertDone();
        new Test(E.class, "foo").assertArgument(0, 3, "foo").assertDone();
        new Test(E.class, "foo bar").assertArgument(0, 3, "foo").assertArgument(4, 7, "bar").assertDone();
        new Test(E.class, "foo bar juu").assertArgument(0, 3, "foo").assertArgument(4, 7, "bar").assertArgument(8, 11, "juu").assertDone();
        new Test(E.class, "foo bar juu daa").assertArgument(0, 3, "foo").assertArgument(4, 11, "bar", "juu").assertArgument(12, 15, "daa").assertDone();
    }

    public void testEmpty() throws Exception {
        class A {
            A() {
            }
        }
        new Test(A.class, "").assertDone();
        new Test(A.class, "-foo").assertDone("-foo");
        new Test(A.class, "foo").assertDone("foo");
    }

    public void testOptions() throws Exception {
        class A {
            @Option(names={"o"})
            String o;
            @Option(names={"p"})
            List<String> p;
            @Option(names={"b"})
            boolean b;

            A() {
            }
        }
        new Test(A.class, "-o foo").assertOption("o", "foo").assertDone();
        new Test(A.class, "-p foo -p bar").assertOption("p", "foo", "bar").assertDone();
        new Test(A.class, "-b foo").assertOption("b", new String[0]).assertDone("foo");
        new Test(A.class, "-b").assertOption("b", new String[0]);
        new Test(A.class, "-o foo -p bar -p juu").assertOption("o", "foo").assertOption("p", "bar", "juu").assertDone();
        new Test(A.class, "-o foo -b -p bar -p juu").assertOption("o", "foo").assertOption("b", new String[0]).assertOption("p", "bar", "juu").assertDone();
        new Test(A.class, "-p foo").assertOption("p", "foo").assertDone();
    }

    public void testMethod() throws Exception {
        class A {
            A() {
            }

            @Command
            void m() {
            }
        }
        new Test(A.class, "m").assertMethod("m").assertDone();
    }

    public void testMixedMethod() throws Exception {
        class A {
            @Option(names={"s"})
            String s;

            A() {
            }

            @Command
            void m(@Option(names={"o"}) String o, @Argument String a) {
            }
        }
        new Test(A.class, "-s foo m -o bar juu").assertSharedOption("s", "foo").assertMethod("m").assertOption("o", "bar").assertArgument(16, 19, "juu").assertDone();
    }

    private static class Test {
        private LinkedList<OptionMatch> sharedOptionMatches;
        private LinkedList<OptionMatch> optionMatches;
        private LinkedList<ArgumentMatch> argumentMatches;
        private String rest;
        private String methodName;

        private <T> Test(Class<T> type, String s) {
            try {
                CommandDescriptorImpl command = CommandFactory.DEFAULT.create(type);
                InvocationMatcher parser = command.invoker();
                InvocationMatch match = parser.match(s);
                if (match.owner() == null) {
                    this.sharedOptionMatches = new LinkedList();
                    this.optionMatches = new LinkedList(match.options());
                    this.argumentMatches = new LinkedList(match.arguments());
                    this.rest = match.getRest();
                    this.methodName = null;
                } else {
                    this.sharedOptionMatches = new LinkedList(match.owner().options());
                    this.optionMatches = new LinkedList(match.options());
                    this.argumentMatches = new LinkedList(match.arguments());
                    this.rest = match.getRest();
                    this.methodName = match.getDescriptor().getName();
                }
            }
            catch (Exception e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
        }

        public Test assertSharedOption(String expectedName, String ... expectedValues) {
            Assert.assertTrue((this.sharedOptionMatches.size() > 0 ? 1 : 0) != 0);
            OptionMatch match = this.sharedOptionMatches.removeFirst();
            Assert.assertEquals((String)expectedName, (String)match.getName());
            ArrayList<String> values = new ArrayList<String>();
            for (LiteralValue value : match.getValues()) {
                values.add(value.getValue());
            }
            Assert.assertEquals(Arrays.asList(expectedValues), values);
            return this;
        }

        public Test assertOption(String expectedName, String ... expectedValues) {
            Assert.assertTrue((this.optionMatches.size() > 0 ? 1 : 0) != 0);
            OptionMatch match = this.optionMatches.removeFirst();
            Assert.assertEquals((String)expectedName, (String)match.getName());
            ArrayList<String> values = new ArrayList<String>();
            for (LiteralValue value : match.getValues()) {
                values.add(value.getValue());
            }
            Assert.assertEquals(Arrays.asList(expectedValues), values);
            return this;
        }

        public Test assertArgument(int start, int end, String ... expectedValues) {
            Assert.assertTrue((this.argumentMatches.size() > 0 ? 1 : 0) != 0);
            ArgumentMatch match = this.argumentMatches.removeFirst();
            Assert.assertEquals((int)start, (int)match.getStart());
            Assert.assertEquals((int)end, (int)match.getEnd());
            ArrayList<String> values = new ArrayList<String>();
            for (LiteralValue value : match.getValues()) {
                values.add(value.getValue());
            }
            Assert.assertEquals(Arrays.asList(expectedValues), values);
            return this;
        }

        public Test assertMethod(String name) {
            Assert.assertEquals((String)this.methodName, (String)name);
            this.methodName = null;
            return this;
        }

        public void assertDone(String expectedRest) {
            Assert.assertEquals((String)expectedRest, (String)this.rest);
            Assert.assertNull((Object)this.methodName);
            Assert.assertEquals(Collections.emptyList(), this.sharedOptionMatches);
            Assert.assertEquals(Collections.emptyList(), this.optionMatches);
            Assert.assertEquals(Collections.emptyList(), this.argumentMatches);
        }

        public void assertDone() {
            this.assertDone("");
        }
    }
}

