/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.lang;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.crsh.cli.Argument;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.Required;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.lang.ClassDescriptor;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.cli.impl.parser.Event;
import org.crsh.cli.impl.parser.Mode;
import org.crsh.cli.impl.parser.Parser;
import org.crsh.cli.impl.tokenizer.Tokenizer;
import org.crsh.cli.impl.tokenizer.TokenizerImpl;

public class ParserTestCase
extends TestCase {
    public void testUnkownClassOption() throws Exception {
        class A {
            A() {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o");
        tester.assertEnd(Event.Stop.Unresolved.NoSuchOption.class, 0);
    }

    public void testUnkownMethodOption1() throws Exception {
        class A {
            A() {
            }

            @Command
            void main() {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o");
        tester.assertMethod("main");
        tester.assertEnd(Event.Stop.Unresolved.NoSuchOption.class, 0);
    }

    public void testUnkownMethodOption2() throws Exception {
        class A {
            A() {
            }

            @Command
            void m() {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "m -o");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.NoSuchOption.class, 2);
    }

    public void testClassOption() throws Exception {
        class A {
            @Option(names={"o"})
            String o;

            A() {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "-o ");
        tester.assertOption("o", new String[0]);
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.class, 3);
        tester = new Tester((CommandDescriptor)cmd, "-o a");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.class, 4);
        tester = new Tester((CommandDescriptor)cmd, "-o a b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
    }

    public void testMethodOption() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) String o) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o");
        tester.assertMethod("main");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "-o a");
        tester.assertMethod("main");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.class, 4);
        tester = new Tester((CommandDescriptor)cmd, "-o a b");
        tester.assertMethod("main");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
    }

    public void testClassOptionList() throws Exception {
        class A {
            @Option(names={"o"})
            List<String> o;

            A() {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "-o a");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.class, 4);
        tester = new Tester((CommandDescriptor)cmd, "-o a -o b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertOption("o", "b");
        tester.assertEnd(Event.Stop.Done.class, 9);
    }

    public void testMethodOptionList() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) List<String> o) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o");
        tester.assertMethod("main");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "-o a");
        tester.assertMethod("main");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.class, 4);
        tester = new Tester((CommandDescriptor)cmd, "-o a -o b");
        tester.assertMethod("main");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertOption("o", "b");
        tester.assertEnd(Event.Stop.Done.class, 9);
    }

    public void testOptions1() throws Exception {
        class A {
            @Option(names={"o"})
            String o;

            A() {
            }

            @Command
            public void main(@Option(names={"p"}) String p) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "-o a");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.class, 4);
        tester = new Tester((CommandDescriptor)cmd, "-o a b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("main");
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
        tester = new Tester((CommandDescriptor)cmd, "-p");
        tester.assertMethod("main");
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "-p a");
        tester.assertMethod("main");
        tester.assertOption("p", "a");
        tester.assertEnd(Event.Stop.Done.class, 4);
        tester = new Tester((CommandDescriptor)cmd, "-p a b");
        tester.assertMethod("main");
        tester.assertOption("p", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
        tester = new Tester((CommandDescriptor)cmd, "-o -p");
        tester.assertOption("o", new String[0]);
        tester.assertSeparator();
        tester.assertMethod("main");
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 5);
        tester = new Tester((CommandDescriptor)cmd, "-o a -p");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("main");
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 7);
        tester = new Tester((CommandDescriptor)cmd, "-o a -p b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("main");
        tester.assertOption("p", "b");
        tester.assertEnd(Event.Stop.Done.class, 9);
    }

    public void testOptions2() throws Exception {
        class A {
            @Option(names={"o"})
            String o;

            A() {
            }

            @Command
            public void m(@Option(names={"p"}) String p) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "-o a");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.class, 4);
        tester = new Tester((CommandDescriptor)cmd, "-o a b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
        tester = new Tester((CommandDescriptor)cmd, "m -p");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 4);
        tester = new Tester((CommandDescriptor)cmd, "m -p a");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", "a");
        tester.assertEnd(Event.Stop.Done.class, 6);
        tester = new Tester((CommandDescriptor)cmd, "m -p a b");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 7);
        tester = new Tester((CommandDescriptor)cmd, "-o a m -p");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 9);
        tester = new Tester((CommandDescriptor)cmd, "-o a m -p b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", "b");
        tester.assertEnd(Event.Stop.Done.class, 11);
        tester = new Tester((CommandDescriptor)cmd, "m -o a -p");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.class, 9);
        tester = new Tester((CommandDescriptor)cmd, "m -o a -p b");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertOption("p", "b");
        tester.assertEnd(Event.Stop.Done.class, 11);
    }

    public void testImplicitSubordinateOption() {
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) String o) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "-o foo");
        tester.assertMethod("main");
        tester.assertOption("o", "foo");
        tester.assertEnd(Event.Stop.Done.class, 6);
    }

    public void testClassArgument() throws Exception {
        class A {
            @Argument(name="arg")
            String arg;

            A() {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a");
        tester.assertArgument("arg", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b");
        tester.assertArgument("arg", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 2);
    }

    public void testMethodArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg") String arg) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("arg", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 2);
    }

    public void testSatisfyAllMethodArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg") String arg) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.class, 2);
    }

    public void testMethodArgumentList() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="args") List<String> args) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("args", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a ");
        tester.assertMethod("main");
        tester.assertArgument("args", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("args", "a", "b");
        tester.assertEnd(Event.Stop.Done.class, 3);
        tester = new Tester((CommandDescriptor)cmd, "a b ");
        tester.assertMethod("main");
        tester.assertArgument("args", "a", "b");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.class, 4);
    }

    public void testSatisfyAllMethodArgumentList() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="args") List<String> args) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("args", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a ", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("args", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "a b", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("args", "a", "b");
        tester.assertEnd(Event.Stop.Done.class, 3);
        tester = new Tester((CommandDescriptor)cmd, "a b ", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("args", "a", "b");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.class, 4);
    }

    public void testMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg1") String arg1, @Argument(name="arg2") String arg2) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.class, 3);
    }

    public void testSatisfyAllMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg1") String arg1, @Argument(name="arg2") String arg2) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.class, 3);
    }

    public void testRequiredMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Required @Argument(name="arg1") String arg1, @Required @Argument(name="arg2") String arg2) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.class, 3);
    }

    public void testSatisfyAllRequiredMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Required @Argument(name="arg1") String arg1, @Required @Argument(name="arg2") String arg2) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.class, 3);
    }

    public void testMixedMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg1") List<String> arg1, @Argument(name="arg2") String arg2) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a", "b");
        tester.assertEnd(Event.Stop.Done.class, 3);
    }

    public void testSatisfyAllMixedMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg1") List<String> arg1, @Argument(name="arg2") String arg2) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg2", "a");
        tester.assertEnd(Event.Stop.Done.class, 1);
        tester = new Tester((CommandDescriptor)cmd, "a b", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.class, 3);
    }

    public void testExplicitMainMethod() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg") String arg) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "main");
        tester.assertMethod("main");
        tester.assertArgument("arg", "main");
        tester.assertEnd(Event.Stop.Done.class, 4);
    }

    public void testSatisfyAllExplicitMainMethod() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg") String arg) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "main", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg", "main");
        tester.assertEnd(Event.Stop.Done.class, 4);
    }

    public void testDoubleDash() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) String o, @Argument(name="arg") String arg) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "--", Mode.COMPLETE);
        tester.assertMethod("main");
        tester.assertEnd(Event.Stop.Unresolved.NoSuchOption.class, 0);
        tester = new Tester((CommandDescriptor)cmd, "-- ", Mode.COMPLETE);
        tester.assertMethod("main");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.class, 3);
        tester = new Tester((CommandDescriptor)cmd, "-- foo", Mode.COMPLETE);
        tester.assertMethod("main");
        tester.assertSeparator();
        tester.assertArgument("arg", "foo");
        tester.assertEnd(Event.Stop.Done.class, 6);
    }

    public void testSatisfyAllDoubleDash() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) String o, @Argument(name="arg") String arg) {
            }
        }
        CommandDescriptorImpl cmd = CommandFactory.DEFAULT.create(A.class);
        Tester tester = new Tester((CommandDescriptor)cmd, "--", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertEnd(Event.Stop.Done.class, 2);
        tester = new Tester((CommandDescriptor)cmd, "-- ", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.class, 3);
        tester = new Tester((CommandDescriptor)cmd, "-- foo", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertSeparator();
        tester.assertArgument("arg", "foo");
        tester.assertEnd(Event.Stop.Done.class, 6);
    }

    private static class Tester<T> {
        private final CommandDescriptor<T> command;
        private Parser parser;

        private Tester(CommandDescriptor<T> command, String s) {
            this(command, s, Mode.COMPLETE);
        }

        private Tester(CommandDescriptor<T> command, String s, Mode mode) {
            this.command = command;
            this.parser = new Parser((Tokenizer)new TokenizerImpl((CharSequence)s), (CommandDescriptor)((ClassDescriptor)command), "main", mode);
        }

        public void assertSeparator() {
            Event event = this.parser.next();
            Assert.assertTrue((String)("was expecting a separator instead of " + event), (boolean)(event instanceof Event.Separator));
        }

        public void assertMethod(String name) {
            Event.Subordinate event = (Event.Subordinate)this.parser.next();
            Assert.assertEquals((String)name, (String)event.getDescriptor().getName());
        }

        public void assertOption(String name, String ... values) {
            Event.Option event = (Event.Option)this.parser.next();
            Assert.assertTrue((boolean)((OptionDescriptor)event.getParameter()).getNames().contains(name));
            Assert.assertEquals(Arrays.asList(values), (Object)event.getStrings());
        }

        public void assertArgument(String name, String ... values) {
            Event.Argument event = (Event.Argument)this.parser.next();
            Assert.assertEquals((String)name, (String)((ArgumentDescriptor)event.getParameter()).getName());
            Assert.assertEquals(Arrays.asList(values), (Object)event.getStrings());
        }

        public void assertEnd(Class expectedClass, int expectedIndex) {
            Event.Stop event = (Event.Stop)this.parser.next();
            Assert.assertEquals((Object)expectedClass, event.getClass());
            Assert.assertEquals((int)expectedIndex, (int)event.getIndex());
        }
    }
}

