/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.descriptor;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.ParameterType;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.Help;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationException;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.ParameterMatch;
import org.crsh.cli.impl.invocation.Resolver;
import org.crsh.cli.type.ValueTypeFactory;

public class HelpDescriptor<T>
extends CommandDescriptorImpl<T> {
    static final OptionDescriptor HELP_OPTION = new OptionDescriptor(null, ParameterType.create(ValueTypeFactory.DEFAULT, Boolean.class), Arrays.asList("h", "help"), new Description("this help", "Display this help message"), false, false, false, null, null);
    private final HelpDescriptor<T> owner;
    private final CommandDescriptorImpl<T> delegate;
    private final LinkedHashMap<String, HelpDescriptor<T>> subordinates;

    public static <T> HelpDescriptor<T> create(CommandDescriptorImpl<T> descriptor) {
        return new HelpDescriptor<T>(descriptor);
    }

    public HelpDescriptor(CommandDescriptorImpl<T> delegate) throws IntrospectionException {
        this(null, delegate);
    }

    private HelpDescriptor(HelpDescriptor<T> owner, CommandDescriptorImpl<T> delegate) throws IntrospectionException {
        super(delegate.getName(), delegate.getDescription());
        for (ParameterDescriptor parameter : delegate.getParameters()) {
            this.addParameter(parameter);
        }
        if (owner == null) {
            this.addParameter(HELP_OPTION);
        }
        LinkedHashMap<String, HelpDescriptor<T>> subordinates = new LinkedHashMap<String, HelpDescriptor<T>>();
        for (CommandDescriptorImpl<T> subordinate : delegate.getSubordinates().values()) {
            subordinates.put(subordinate.getName(), new HelpDescriptor<T>(this, subordinate));
        }
        this.owner = owner;
        this.delegate = delegate;
        this.subordinates = subordinates;
    }

    public CommandDescriptor<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public CommandInvoker<T> getInvoker(InvocationMatch<T> match) {
        final CommandInvoker<T> invoker = this.delegate.getInvoker(match);
        ParameterMatch<OptionDescriptor> helpDesc = null;
        for (InvocationMatch<T> current = match; current != null && helpDesc == null; current = current.owner()) {
            helpDesc = current.getParameter(HELP_OPTION);
        }
        final boolean help = helpDesc != null || invoker == null;
        return new CommandInvoker<T>(){

            @Override
            public Class<?> getReturnType() {
                if (help) {
                    return String.class;
                }
                return invoker.getReturnType();
            }

            @Override
            public Type getGenericReturnType() {
                if (help) {
                    return String.class;
                }
                return invoker.getGenericReturnType();
            }

            @Override
            public Class<?>[] getParameterTypes() {
                return invoker != null ? invoker.getParameterTypes() : new Class[]{};
            }

            @Override
            public Type[] getGenericParameterTypes() {
                return invoker != null ? invoker.getGenericParameterTypes() : new Type[]{};
            }

            @Override
            public Object invoke(Resolver resolver, T command) throws InvocationException, SyntaxException {
                if (help) {
                    return new Help(HelpDescriptor.this.delegate);
                }
                return invoker.invoke(resolver, command);
            }
        };
    }

    @Override
    public Class<T> getType() {
        return this.delegate.getType();
    }

    @Override
    public CommandDescriptor<T> getOwner() {
        return this.owner;
    }

    @Override
    public Map<String, ? extends HelpDescriptor<T>> getSubordinates() {
        return this.subordinates;
    }

    @Override
    public HelpDescriptor<T> getSubordinate(String name) {
        return this.subordinates.get(name);
    }
}

