/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.ArrayList;
import java.util.List;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.matcher.tokenizer.Token;

public abstract class Event {

    public static abstract class Stop
    extends Event {
        public abstract int getIndex();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Unresolved<T extends Token>
        extends Stop {
            private final T token;

            Unresolved(T token) {
                this.token = token;
            }

            @Override
            public final int getIndex() {
                return ((Token)this.token).getFrom();
            }

            public T getToken() {
                return this.token;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class TooManyArguments
            extends Unresolved<Token.Literal> {
                TooManyArguments(Token.Literal token) {
                    super(token);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class NoSuchOption
            extends Unresolved<Token.Literal.Option> {
                public NoSuchOption(Token.Literal.Option token) {
                    super(token);
                }

                public static class Method
                extends NoSuchOption {
                    Method(Token.Literal.Option token) {
                        super(token);
                    }
                }

                public static class Class
                extends NoSuchOption {
                    Class(Token.Literal.Option token) {
                        super(token);
                    }
                }
            }
        }

        public static abstract class Done
        extends Stop {
            private final int index;

            Done(int index) {
                this.index = index;
            }

            public int getIndex() {
                return this.index;
            }

            public static final class Arg
            extends Done {
                public Arg(int index) {
                    super(index);
                }
            }

            public static final class Option
            extends Done {
                public Option(int index) {
                    super(index);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Method
    extends Event {
        private final MethodDescriptor<?> descriptor;

        Method(MethodDescriptor<?> descriptor) {
            this.descriptor = descriptor;
        }

        public MethodDescriptor<?> getDescriptor() {
            return this.descriptor;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Explicit
        extends Method {
            private final Token.Literal.Word token;

            public Explicit(MethodDescriptor<?> descriptor, Token.Literal.Word token) {
                super(descriptor);
                this.token = token;
            }

            public Token.Literal.Word getToken() {
                return this.token;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Implicit
        extends Method {
            private final Token.Literal trigger;

            public Implicit(MethodDescriptor<?> descriptor, Token.Literal trigger) {
                super(descriptor);
                this.trigger = trigger;
            }

            public Token.Literal getTrigger() {
                return this.trigger;
            }
        }
    }

    public static final class Separator
    extends Event {
        private final Token.Whitespace token;

        Separator(Token.Whitespace token) {
            this.token = token;
        }

        public Token.Whitespace getToken() {
            return this.token;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Argument
    extends Parameter<Token.Literal, ArgumentDescriptor<?>> {
        Argument(ArgumentDescriptor<?> descriptor, List<Token.Literal> values) throws IllegalArgumentException {
            super(descriptor, values);
            if (values.size() == 0) {
                throw new IllegalArgumentException("No empty values");
            }
        }

        @Override
        public int getFrom() {
            return ((Token)this.peekFirst()).getFrom();
        }

        @Override
        public int getTo() {
            return ((Token)this.peekLast()).getTo();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Option
    extends Parameter<Token.Literal.Word, OptionDescriptor<?>> {
        private final Token.Literal.Option token;

        Option(OptionDescriptor<?> descriptor, Token.Literal.Option token, List<Token.Literal.Word> values) {
            super(descriptor, values);
            this.token = token;
        }

        public final Token.Literal.Option getToken() {
            return this.token;
        }

        @Override
        public int getFrom() {
            return this.token.getFrom();
        }

        @Override
        public int getTo() {
            return this.values.size() == 0 ? this.token.getTo() : ((Token.Literal.Word)this.peekLast()).getTo();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Parameter<T extends Token.Literal, D extends ParameterDescriptor<?>>
    extends Event {
        protected final D descriptor;
        protected final List<T> values;

        public Parameter(D descriptor, List<T> values) {
            this.descriptor = descriptor;
            this.values = values;
        }

        public final D getDescriptor() {
            return this.descriptor;
        }

        public final List<T> getValues() {
            return this.values;
        }

        public final T peekFirst() {
            return (T)(this.values.isEmpty() ? null : (Token.Literal)this.values.get(0));
        }

        public final T peekLast() {
            int size = this.values.size();
            return (T)(size == 0 ? null : (Token.Literal)this.values.get(size - 1));
        }

        public final List<String> getStrings() {
            ArrayList<String> strings = new ArrayList<String>();
            for (Token.Literal value : this.values) {
                strings.add(value.getValue());
            }
            return strings;
        }

        public abstract int getFrom();

        public abstract int getTo();

        public String toString() {
            return this.getClass().getSimpleName() + "[descriptor=" + this.descriptor + ",values=" + this.values + "]";
        }
    }

    public static final class DoubleDash
    extends Event {
        protected final Token.Literal.Option.Long token;

        public DoubleDash(Token.Literal.Option.Long token) {
            this.token = token;
        }
    }
}

