/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Map;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.Description;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.Util;
import org.crsh.cmdline.binding.ClassFieldBinding;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.matcher.impl.MatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor<T>
extends CommandDescriptor<T, ClassFieldBinding> {
    private static final Logger log = LoggerFactory.getLogger(ClassDescriptor.class);
    private final Class<T> type;
    private final Map<String, MethodDescriptor<T>> methods;

    ClassDescriptor(Class<T> type, Map<String, MethodDescriptor<T>> methods, Description info) throws IntrospectionException {
        super(type.getSimpleName().toLowerCase(), info);
        this.methods = methods;
        this.type = type;
    }

    public Matcher<T> matcher() {
        return new MatcherImpl(this);
    }

    public Matcher<T> matcher(String mainName) {
        return new MatcherImpl(mainName, this);
    }

    @Override
    void addParameter(ParameterDescriptor<ClassFieldBinding> parameter) throws IntrospectionException {
        if (parameter instanceof OptionDescriptor) {
            OptionDescriptor option = (OptionDescriptor)parameter;
            HashSet<String> blah = new HashSet<String>();
            for (String string : option.getNames()) {
                blah.add((string.length() == 1 ? "-" : "--") + string);
            }
            for (MethodDescriptor methodDescriptor : this.methods.values()) {
                HashSet<String> diff = new HashSet<String>(methodDescriptor.getOptionNames());
                diff.retainAll(blah);
                if (diff.size() <= 0) continue;
                throw new IntrospectionException("Cannot add method " + methodDescriptor.getName() + " because it has common " + " options with its class: " + diff);
            }
        }
        super.addParameter(parameter);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Map<String, ? extends CommandDescriptor<T, ?>> getSubordinates() {
        return this.methods;
    }

    @Override
    public OptionDescriptor<?> findOption(String name) {
        return this.getOption(name);
    }

    @Override
    public void printUsage(Appendable writer) throws IOException {
        if (this.methods.size() == 1) {
            this.methods.values().iterator().next().printUsage(writer);
        } else {
            writer.append("usage: ").append(this.getName());
            for (OptionDescriptor option : this.getOptions()) {
                option.printUsage(writer);
            }
            writer.append(" COMMAND [ARGS]\n\n");
            writer.append("The most commonly used ").append(this.getName()).append(" commands are:\n");
            String format = "   %1$-16s %2$s\n";
            for (MethodDescriptor<T> method : this.getMethods()) {
                Formatter formatter = new Formatter(writer);
                formatter.format(format, method.getName(), method.getUsage());
            }
        }
    }

    @Override
    public void printMan(Appendable writer) throws IOException {
        if (this.methods.size() == 1) {
            this.methods.values().iterator().next().printMan(writer);
        } else {
            writer.append("NAME\n");
            writer.append(Util.MAN_TAB).append(this.getName());
            if (this.getUsage().length() > 0) {
                writer.append(" - ").append(this.getUsage());
            }
            writer.append("\n\n");
            writer.append("SYNOPSIS\n");
            writer.append(Util.MAN_TAB).append(this.getName());
            for (OptionDescriptor option : this.getOptions()) {
                writer.append(" ");
                option.printUsage(writer);
            }
            writer.append(" COMMAND [ARGS]\n\n");
            String man = this.getDescription().getMan();
            if (man.length() > 0) {
                writer.append("DESCRIPTION\n");
                Util.indent(Util.MAN_TAB, (CharSequence)man, writer);
                writer.append("\n\n");
            }
            if (this.getOptions().size() > 0) {
                writer.append("PARAMETERS\n");
                for (OptionDescriptor optionDescriptor : this.getOptions()) {
                    writer.append(Util.MAN_TAB);
                    optionDescriptor.printUsage(writer);
                    String optionText = optionDescriptor.getDescription().getBestEffortMan();
                    if (optionText.length() > 0) {
                        writer.append("\n");
                        Util.indent(Util.MAN_TAB_EXTRA, (CharSequence)optionText, writer);
                    }
                    writer.append("\n\n");
                }
            }
            writer.append("COMMANDS\n");
            for (MethodDescriptor methodDescriptor : this.getMethods()) {
                writer.append(Util.MAN_TAB).append(methodDescriptor.getName());
                String methodText = methodDescriptor.getDescription().getBestEffortMan();
                if (methodText.length() > 0) {
                    writer.append("\n");
                    Util.indent(Util.MAN_TAB_EXTRA, (CharSequence)methodText, writer);
                }
                writer.append("\n\n");
            }
        }
    }

    public Iterable<MethodDescriptor<T>> getMethods() {
        return this.methods.values();
    }

    public MethodDescriptor<T> getMethod(String name) {
        return this.methods.get(name);
    }
}

