/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.type;

import java.util.Properties;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.crsh.cmdline.type.ValueType;
import org.crsh.cmdline.type.ValueTypeFactory;

public class SimpleValueTypeTestCase
extends TestCase {
    private ValueTypeFactory factory = new ValueTypeFactory(SimpleValueTypeTestCase.class.getClassLoader());

    public void testString() throws Exception {
        ValueType stringVT = this.factory.get(String.class);
        SimpleValueTypeTestCase.assertEquals(String.class, (Object)stringVT.getType());
        String s = (String)stringVT.parse("abc");
        SimpleValueTypeTestCase.assertEquals((String)"abc", (String)s);
    }

    public void testInteger() throws Exception {
        ValueType stringVT = this.factory.get(Integer.class);
        SimpleValueTypeTestCase.assertEquals(Integer.class, (Object)stringVT.getType());
        int i = (Integer)stringVT.parse("123");
        SimpleValueTypeTestCase.assertEquals((int)123, (int)i);
    }

    public void testBoolean() throws Exception {
        ValueType booleanVT = this.factory.get(Boolean.class);
        SimpleValueTypeTestCase.assertEquals(Boolean.class, (Object)booleanVT.getType());
        boolean b = (Boolean)booleanVT.parse("false");
        SimpleValueTypeTestCase.assertEquals((boolean)false, (boolean)b);
    }

    public void testEnum() throws Exception {
        ValueType stringVT = this.factory.get(Color.class);
        SimpleValueTypeTestCase.assertEquals(Enum.class, (Object)stringVT.getType());
        Color red = (Color)((Object)stringVT.parse(Color.class, "RED"));
        SimpleValueTypeTestCase.assertEquals((Object)((Object)Color.RED), (Object)((Object)red));
    }

    public void testProperties() throws Exception {
        ValueType propertiesVT = this.factory.get(Properties.class);
        Properties props = (Properties)propertiesVT.parse("org.apache.jackrabbit.repository.conf=repository-in-memory.xml;org.apache.jackrabbit.repository.home=/home/ehugonnet/tmp/crash/jcr/target/test-classes/conf/transient");
        SimpleValueTypeTestCase.assertNotNull((Object)props);
        SimpleValueTypeTestCase.assertEquals((int)2, (int)props.size());
        SimpleValueTypeTestCase.assertEquals((Object)"repository-in-memory.xml", (Object)props.get("org.apache.jackrabbit.repository.conf"));
        SimpleValueTypeTestCase.assertEquals((Object)"/home/ehugonnet/tmp/crash/jcr/target/test-classes/conf/transient", (Object)props.get("org.apache.jackrabbit.repository.home"));
    }

    public void testObjectName() throws Exception {
        ValueType propertiesVT = this.factory.get(ObjectName.class);
        ObjectName name = (ObjectName)propertiesVT.parse(ObjectName.class, "foo:bar=juu");
        SimpleValueTypeTestCase.assertEquals((Object)new ObjectName("foo", "bar", "juu"), (Object)name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Color {
        RED,
        BLUE;

    }
}

