/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.util.LinkedList;
import java.util.List;
import org.crsh.command.ScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LineFormat {
    LineFormat() {
    }

    public static List<String> format(String s) throws ScriptException {
        if (s == null) {
            throw new NullPointerException();
        }
        LinkedList<String> chunks = new LinkedList<String>();
        StringBuilder chunk = new StringBuilder();
        Character lastQuote = null;
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': {
                    if (lastQuote == null) {
                        if (chunk.length() <= 0) continue block4;
                        chunks.addLast(chunk.toString());
                        chunk.setLength(0);
                        continue block4;
                    }
                    chunk.append(c);
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    if (lastQuote == null) {
                        lastQuote = Character.valueOf(c);
                        chunk.append(c);
                        continue block4;
                    }
                    if (lastQuote.charValue() != c) {
                        chunk.append(c);
                        continue block4;
                    }
                    chunk.append(c);
                    lastQuote = null;
                    continue block4;
                }
                default: {
                    chunk.append(c);
                }
            }
        }
        if (lastQuote != null) {
            throw new ScriptException("Quote " + lastQuote + " is not closed");
        }
        if (chunk.length() > 0) {
            chunks.addLast(chunk.toString());
        }
        return chunks;
    }
}

