/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.crsh.shell.Resource;
import org.crsh.shell.ShellContext;
import org.crsh.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletShellContext
implements ShellContext {
    private final ServletContext servletContext;
    private final ClassLoader loader;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String version;

    public ServletShellContext(ServletContext servletContext, ClassLoader loader) {
        if (servletContext == null) {
            throw new NullPointerException();
        }
        if (loader == null) {
            throw new NullPointerException();
        }
        String version = null;
        try {
            Properties props = new Properties();
            InputStream in = servletContext.getResourceAsStream("/META-INF/maven/org.crsh/crsh.core/pom.properties");
            if (in != null) {
                props.load(in);
                version = props.getProperty("version");
            }
        }
        catch (Exception e) {
            this.log.error("Could not load maven properties", (Throwable)e);
        }
        if (version == null) {
            this.log.warn("No version found will use unknown value instead");
            version = "unkown";
        }
        this.servletContext = servletContext;
        this.loader = loader;
        this.version = version;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getVersion() {
        return this.version;
    }

    public Resource loadResource(String resourceId) {
        Resource res = null;
        try {
            URL url = this.servletContext.getResource("/WEB-INF/" + resourceId);
            if (url != null) {
                URLConnection conn = url.openConnection();
                long timestamp = conn.getLastModified();
                InputStream in = url.openStream();
                String content = IO.readAsUTF8(in);
                res = new Resource(content, timestamp);
            }
        }
        catch (IOException e) {
            this.log.warn("Could not find resource " + resourceId, (Throwable)e);
        }
        return res;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }
}

