/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.crsh.command.ShellCommand;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.ShellResponseContext;
import org.crsh.shell.impl.CRaSH;
import org.crsh.shell.impl.CommandContextImpl;

abstract class AST {
    AST() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Term
    extends AST {
        final List<String> commandDefinition;
        final Term next;
        private ShellCommand command;
        private String[] args;

        Term(List<String> commandDefinition, Term next) {
            this.commandDefinition = commandDefinition;
            this.next = next;
        }

        Term(List<String> commandDefinition) {
            this.commandDefinition = commandDefinition;
            this.next = null;
        }

        private ShellResponse.UnkownCommand createCommands(CRaSH crash) {
            ShellCommand command = crash.getCommand(this.commandDefinition.get(0));
            if (command == null) {
                return new ShellResponse.UnkownCommand(this.commandDefinition.get(0));
            }
            String[] args = new String[this.commandDefinition.size() - 1];
            this.commandDefinition.subList(1, this.commandDefinition.size()).toArray(args);
            this.args = args;
            this.command = command;
            if (this.next != null) {
                return this.next.createCommands(crash);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Expr
    extends AST {
        final Term term;
        final Expr next;

        Expr(Term term) {
            this.term = term;
            this.next = null;
        }

        Expr(Term term, Expr next) {
            this.term = term;
            this.next = next;
        }

        ShellResponse.UnkownCommand createCommands(CRaSH crash) {
            ShellResponse.UnkownCommand resp = this.term.createCommands(crash);
            if (resp == null && this.next != null) {
                return this.next.createCommands(crash);
            }
            return resp;
        }

        ShellResponse execute(ShellResponseContext responseContext, Map<String, Object> attributes) {
            try {
                return this.execute(responseContext, attributes, null);
            }
            catch (Throwable t) {
                return new ShellResponse.Error(ErrorType.EVALUATION, t);
            }
        }

        private ShellResponse execute(ShellResponseContext responseContext, Map<String, Object> attributes, ArrayList consumed) {
            ArrayList produced = new ArrayList();
            StringBuilder out = new StringBuilder();
            Term current = this.term;
            while (current != null) {
                CommandContextImpl ctx = current.command.getConsumedType() == Void.class ? new CommandContextImpl(responseContext, null, attributes) : new CommandContextImpl(responseContext, consumed, attributes);
                current.command.execute(ctx, current.args);
                if (ctx.getBuffer() != null) {
                    out.append(ctx.getBuffer().toString());
                }
                if (current.command.getProducedType() != Void.class) {
                    produced.addAll(ctx.getProducedItems());
                }
                current = current.next;
            }
            if (this.next != null) {
                return this.next.execute(responseContext, attributes, produced);
            }
            ShellResponse.Ok response = out.length() > 0 ? new ShellResponse.Display(produced, out.toString()) : new ShellResponse.Ok(produced);
            return response;
        }
    }
}

