/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.crsh.term.CodeType;
import org.crsh.term.Term;
import org.crsh.term.TermAction;
import org.crsh.term.TermIO;
import org.crsh.term.TermProcessor;
import org.crsh.term.TermResponseContext;
import org.crsh.util.Input;
import org.crsh.util.InputDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTerm
extends InputDecoder
implements Term {
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_OPEN = 1;
    private static final int STATUS_CLOSED = 2;
    private static final int STATUS_WANT_CLOSE = 3;
    private static final int STATUS_CLOSING = 4;
    private final Logger log = LoggerFactory.getLogger(BaseTerm.class);
    private final TermProcessor processor;
    private final AtomicInteger status;
    private final Object lock = new Object();
    private final LinkedList<Awaiter> awaiters = new LinkedList();
    private final LinkedList<String> history;
    private String historyBuffer;
    private int historyCursor;
    private String prompt;
    private final TermIO io;

    public BaseTerm(TermIO io) {
        this(io, null);
    }

    public BaseTerm(TermIO io, TermProcessor processor) {
        this.processor = processor;
        this.status = new AtomicInteger(0);
        this.history = new LinkedList();
        this.historyBuffer = null;
        this.historyCursor = -1;
        this.io = io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.status.compareAndSet(0, 1)) {
            throw new IllegalStateException();
        }
        TermAction action = new TermAction.Init();
        while (this.status.get() == 1) {
            if (action == null) {
                try {
                    action = this._read();
                    this.log.debug("read term data " + action);
                }
                catch (IOException e) {
                    if (this.status.get() == 1) {
                        this.log.error("Could not read term data", (Throwable)e);
                    }
                    this.log.debug("Exception but term is considered as closed", (Throwable)e);
                    continue;
                }
            }
            Awaiter awaiter = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.awaiters.size() > 0) {
                    awaiter = this.awaiters.removeFirst();
                }
            }
            TermAction action2 = action;
            action = null;
            if (awaiter != null) {
                awaiter.give(action2);
                continue;
            }
            TermResponseContext ctx = new TermResponseContext(){

                public void setEcho(boolean echo) {
                    BaseTerm.this.setEchoing(echo);
                }

                public TermAction read() throws IOException {
                    return BaseTerm.this.read();
                }

                public void write(String msg) throws IOException {
                    BaseTerm.this.write(msg);
                }

                public void setPrompt(String prompt) {
                    BaseTerm.this.prompt = prompt;
                }

                public void done(boolean close) {
                    try {
                        String p = BaseTerm.this.prompt == null ? "%" : BaseTerm.this.prompt;
                        BaseTerm.this.write("\r\n" + p);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (close && BaseTerm.this.status.compareAndSet(1, 3)) {
                        BaseTerm.this.io.close();
                    }
                }
            };
            boolean processed = this.processor.process(action2, ctx);
            if (!processed) {
                this.log.debug("Pushing back action " + action2);
                action = action2;
                continue;
            }
            if (!(action2 instanceof TermAction.ReadLine)) continue;
            String line = ((TermAction.ReadLine)action2).getLine();
            this.historyCursor = -1;
            this.historyBuffer = null;
            if (line.length() <= 0) continue;
            this.history.addFirst(((TermAction.ReadLine)action2).getLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermAction read() throws IOException {
        Awaiter awaiter;
        Object object = this.lock;
        synchronized (object) {
            awaiter = new Awaiter();
            this.awaiters.add(awaiter);
        }
        TermAction taken = awaiter.take();
        return taken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.status.compareAndSet(1, 3);
        if (this.status.compareAndSet(3, 4)) {
            try {
                this.log.debug("Closing connection");
                this.io.flush();
                this.io.close();
            }
            catch (IOException e) {
                this.log.debug("Exception thrown during term close()", (Throwable)e);
            }
            finally {
                this.status.set(2);
            }
        }
    }

    public TermAction _read() throws IOException {
        block7: do {
            int code = this.io.read();
            CodeType type = this.io.getType(code);
            switch (type) {
                case DELETE: {
                    this.appendDel();
                    break;
                }
                case UP: 
                case DOWN: {
                    int nextHistoryCursor = this.historyCursor + (type == CodeType.UP ? 1 : -1);
                    if (nextHistoryCursor < -1 || nextHistoryCursor >= this.history.size()) continue block7;
                    String s = nextHistoryCursor == -1 ? this.historyBuffer : this.history.get(nextHistoryCursor);
                    String t = this.set(s);
                    if (this.historyCursor == -1) {
                        this.historyBuffer = t;
                    }
                    if (nextHistoryCursor == -1) {
                        this.historyBuffer = null;
                    }
                    this.historyCursor = nextHistoryCursor;
                    break;
                }
                case RIGHT: {
                    this.moveRight();
                    break;
                }
                case LEFT: {
                    this.moveLeft();
                    break;
                }
                case CHAR: {
                    if (code >= 0 && code < 128) {
                        if (code == 3) {
                            this.log.debug("Want to cancel evaluation");
                            return new TermAction.CancelEvaluation();
                        }
                        if (code == 10) {
                            this.appendData("\r\n");
                            break;
                        }
                        this.appendData((char)code);
                        break;
                    }
                    this.log.debug("Unhandled char " + code);
                }
            }
        } while (!this.hasNext());
        Input input = this.next();
        if (input instanceof Input.Chars) {
            return new TermAction.ReadLine(((Input.Chars)input).getValue());
        }
        throw new UnsupportedOperationException();
    }

    public void write(String msg) throws IOException {
        this.io.write(msg);
        this.io.flush();
    }

    protected void doEchoCRLF() throws IOException {
        this.io.writeCRLF();
        this.io.flush();
    }

    protected void doEchoDel() throws IOException {
        this.io.writeDel();
        this.io.flush();
    }

    protected void doEcho(String s) throws IOException {
        this.io.write(s);
        this.io.flush();
    }

    protected boolean doMoveRight() throws IOException {
        return this.io.moveRight();
    }

    protected boolean doMoveLeft() throws IOException {
        return this.io.moveLeft();
    }

    private static class Awaiter {
        TermAction action;

        private Awaiter() {
        }

        public synchronized void give(TermAction action) {
            this.action = action;
            this.notify();
        }

        public synchronized TermAction take() {
            try {
                this.wait();
                return this.action;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

