/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.IOException;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.io.ShellWriterContext;

public class LineFeedWriter
implements ShellWriter {
    private static final int NOT_PADDED = 0;
    private static final int PADDING = 1;
    private static final int PADDED = 2;
    private final Appendable out;
    private final String lineFeed;
    private int status;

    public LineFeedWriter(Appendable out) {
        this(out, "\r\n");
    }

    public LineFeedWriter(Appendable out, String lineFeed) {
        this.out = out;
        this.lineFeed = lineFeed;
        this.status = 0;
    }

    public Appendable append(char c) throws IOException {
        return this.append(null, c);
    }

    public ShellWriter append(ShellWriterContext ctx, char c) throws IOException {
        return this.append(ctx, (CharSequence)Character.toString(c));
    }

    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.append(null, csq, start, end);
    }

    public Appendable append(CharSequence csq) throws IOException {
        return this.append(null, csq);
    }

    public ShellWriter append(ShellWriterContext ctx, CharSequence csq) throws IOException {
        return this.append(ctx, csq, 0, csq.length());
    }

    public ShellWriter append(ShellWriterContext ctx, CharSequence csq, int start, int end) throws IOException {
        int previous = start;
        int to = start + end;
        for (int i = start; i < to; ++i) {
            char c = csq.charAt(i);
            if (c == '\r') {
                if (i > previous) {
                    this.realAppend(ctx, csq, previous, i);
                }
                previous = i + 1;
                continue;
            }
            if (c != '\n') continue;
            if (i > previous) {
                this.realAppend(ctx, csq, previous, i);
            }
            this.writeLF(ctx);
            previous = i + 1;
            ++i;
        }
        if (to != previous) {
            this.realAppend(ctx, csq, previous, to);
        }
        return this;
    }

    private void realAppend(ShellWriterContext ctx, CharSequence csq, int off, int end) throws IOException {
        if (end > off) {
            switch (this.status) {
                case 0: {
                    if (ctx != null) {
                        this.status = 1;
                        ctx.pad((Appendable)this);
                    }
                    this.status = 2;
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.out.append(csq, off, end);
            switch (this.status) {
                case 1: {
                    break;
                }
                case 2: {
                    if (ctx == null) break;
                    ctx.text(csq, off, end);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private void writeLF(ShellWriterContext ctx) throws IOException {
        switch (this.status) {
            case 1: {
                throw new IllegalStateException();
            }
            case 2: {
                this.status = 0;
            }
            case 0: {
                this.out.append(this.lineFeed);
                if (ctx == null) break;
                ctx.lineFeed();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

