/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class TypeResolver {
    public static Type resolve(Type implementation, Class<?> type, int parameterIndex) {
        if (implementation == null) {
            throw new NullPointerException();
        }
        if (implementation == type) {
            TypeVariable<Class<?>>[] tp = type.getTypeParameters();
            if (parameterIndex < tp.length) {
                return tp[parameterIndex];
            }
            throw new IllegalArgumentException();
        }
        if (implementation instanceof Class) {
            Class c = (Class)implementation;
            Type gsc = c.getGenericSuperclass();
            Type resolved = null;
            if (gsc == null || (resolved = TypeResolver.resolve((Type)gsc, type, (int)parameterIndex)) == null) {
                // empty if block
            }
            return resolved;
        }
        if (implementation instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)implementation;
            Type[] typeArgs = pt.getActualTypeArguments();
            Type rawType = pt.getRawType();
            if (rawType == type) {
                return typeArgs[parameterIndex];
            }
            if (rawType instanceof Class) {
                Class classRawType = (Class)rawType;
                Type resolved = TypeResolver.resolve((Type)classRawType, type, (int)parameterIndex);
                if (resolved == null) {
                    return null;
                }
                if (resolved instanceof TypeVariable) {
                    TypeVariable resolvedTV = (TypeVariable)resolved;
                    TypeVariable<Class<T>>[] a = classRawType.getTypeParameters();
                    for (int i = 0; i < a.length; ++i) {
                        if (!a[i].equals(resolvedTV)) continue;
                        return TypeResolver.resolve((Type)implementation, (Class)classRawType, (int)i);
                    }
                    throw new AssertionError();
                }
                throw new UnsupportedOperationException("Cannot support resolution of " + resolved);
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("todo " + implementation + " " + implementation.getClass());
    }
}

