/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import org.crsh.shell.connector.Connector;
import org.crsh.shell.connector.ConnectorResponseContext;
import org.crsh.term.TermAction;
import org.crsh.term.TermProcessor;
import org.crsh.term.TermResponseContext;
import org.crsh.term.TermStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermShellAdapter
implements TermProcessor {
    private final Logger log = LoggerFactory.getLogger(TermShellAdapter.class);
    private final Connector connector;
    private volatile TermStatus status;

    public TermShellAdapter(Connector connector) {
        this.connector = connector;
        this.status = TermStatus.READY;
    }

    public String getPrompt() {
        return this.connector.getPrompt();
    }

    public TermStatus getStatus() {
        return this.status;
    }

    public void close() {
    }

    public boolean process(TermAction action, TermResponseContext responseContext) {
        try {
            return this._process(action, responseContext);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean _process(TermAction action, final TermResponseContext responseContext) throws IOException {
        boolean processed;
        if (action instanceof TermAction.Init) {
            String welcome = this.connector.open();
            responseContext.write(welcome);
            return true;
        }
        switch (this.status) {
            case READY: {
                if (action instanceof TermAction.ReadLine) {
                    String line = ((TermAction.ReadLine)action).getLine();
                    this.status = TermStatus.PROCESSING;
                    this.log.debug("Submitting command " + line);
                    this.connector.submitEvaluation(line, new ConnectorResponseContext(){

                        public void completed(String s) {
                            TermShellAdapter.this.log.debug("Command completed with result " + s);
                            try {
                                responseContext.write(s);
                            }
                            catch (IOException e) {
                                TermShellAdapter.this.log.error("Write to term failure", (Throwable)e);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public String readLine(String s, boolean echo) {
                            try {
                                TermShellAdapter.this.status = TermStatus.READING_INPUT;
                                responseContext.setEcho(echo);
                                responseContext.write(s);
                                TermAction action = responseContext.read();
                                String line = null;
                                if (action instanceof TermAction.ReadLine) {
                                    line = ((TermAction.ReadLine)action).getLine();
                                    TermShellAdapter.this.log.debug("Read from console");
                                } else {
                                    TermShellAdapter.this.log.debug("Ignoring action " + action + " returning null");
                                }
                                responseContext.write("\r\n");
                                String string = line;
                                return string;
                            }
                            catch (Exception e) {
                                TermShellAdapter.this.log.error("Reading from console failed", (Throwable)e);
                                String string = null;
                                return string;
                            }
                            finally {
                                responseContext.setEcho(true);
                                TermShellAdapter.this.status = TermStatus.PROCESSING;
                            }
                        }

                        public void done(boolean close) {
                            if (close) {
                                TermShellAdapter.this.status = TermStatus.SHUTDOWN;
                            } else {
                                TermShellAdapter.this.status = TermStatus.READY;
                            }
                            responseContext.done(close);
                        }

                        public void setPrompt(String prompt) {
                            responseContext.setPrompt(prompt);
                        }
                    });
                } else if (action instanceof TermAction.CancelEvaluation) {
                    responseContext.done(false);
                }
                processed = true;
                break;
            }
            case READING_INPUT: {
                processed = false;
                break;
            }
            case PROCESSING: {
                if (action instanceof TermAction.CancelEvaluation) {
                    if (this.connector.cancelEvalutation()) {
                        this.log.debug("Evaluation cancelled");
                    } else {
                        this.log.debug("Attempt to cancel evaluation failed");
                    }
                    responseContext.done(false);
                } else {
                    this.log.debug("Ignoring action " + action);
                }
                processed = true;
                break;
            }
            case SHUTDOWN: {
                throw new AssertionError((Object)"maybe todo");
            }
            default: {
                throw new AssertionError();
            }
        }
        return processed;
    }
}

