/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public class JCRUtils {
    public static final int PATH = 8;
    public static final int STRING = 1;
    public static final int DATE = 5;
    public static final int DOUBLE = 4;
    public static final int LONG = 3;
    public static final int BOOLEAN = 6;
    public static final int REFERENCE = 9;
    public static final int BINARY = 2;

    private JCRUtils() {
    }

    public static Property getProperty(Node node, String propertyName) throws RepositoryException {
        return node.getProperty(propertyName);
    }

    public static void setProperty(Node node, String propertyName, boolean value) throws RepositoryException {
        node.setProperty(propertyName, value);
    }

    public static void setProperty(Node node, String propertyName, Value value) throws RepositoryException {
        node.setProperty(propertyName, value);
    }

    public static boolean isJCRPropertyType(Object value) {
        return value instanceof String || value instanceof Node || value instanceof Long || value instanceof Boolean || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Float || value instanceof Double || value instanceof Calendar || value instanceof InputStream || value instanceof Value[];
    }

    public static String encodeName(String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                builder.append(c);
                continue;
            }
            String val = Integer.toString(c);
            int padding = 4 - val.length();
            builder.append("_x");
            while (padding > 0) {
                builder.append("0");
            }
            builder.append(val);
        }
        return builder.toString();
    }

    public static String decodeName(String name) {
        throw new UnsupportedOperationException();
    }
}

