/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.connector.sshd;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.server.Environment;
import org.crsh.connector.ShellConnector;
import org.crsh.connector.sshd.AbstractCommand;
import org.crsh.connector.sshd.SSHContext;
import org.crsh.connector.sshd.SSHReader;
import org.crsh.shell.ShellBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRaSHCommand
extends AbstractCommand
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ShellBuilder builder;
    private Thread thread;
    private SSHContext context;
    private ShellConnector connector;

    public CRaSHCommand(ShellBuilder builder) {
        this.builder = builder;
    }

    public void start(Environment env) throws IOException {
        this.context = new SSHContext(((Integer)env.getPtyModes().get(PtyMode.VERASE)).intValue());
        this.connector = new ShellConnector(this.builder);
        this.thread = new Thread((Runnable)this, "CRaSH");
        this.thread.start();
    }

    public void destroy() {
        this.connector.close();
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(this.out);
            SSHReader reader = new SSHReader((Reader)new InputStreamReader(this.in), this.context.verase, (Writer)writer);
            String welcome = this.connector.open();
            writer.write(welcome);
            writer.flush();
            do {
                String request;
                if ((request = reader.nextLine()) == null) {
                    break;
                }
                String response = this.connector.evaluate(request);
                writer.write(response);
                writer.flush();
            } while (!this.connector.isClosed());
        }
        catch (Exception e) {
            this.log.error("Error when executing command", (Throwable)e);
        }
        finally {
            this.callback.onExit(0);
        }
    }
}

