/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.connector;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.Future;
import org.crsh.Info;
import org.crsh.connector.ConnectorStatus;
import org.crsh.connector.ShellConnector;
import org.crsh.display.DisplayContext;
import org.crsh.display.SimpleDisplayContext;
import org.crsh.display.structure.Element;
import org.crsh.shell.ScriptException;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellBuilder;
import org.crsh.shell.ShellResponse;
import org.crsh.util.CompletionHandler;
import org.crsh.util.ImmediateFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellConnector {
    private Shell shell;
    private ConnectorStatus status;
    private Future<ShellResponse> futureResponse;
    private String lastLine;
    private final Object lock;

    public ShellConnector(ShellBuilder builder) {
        this.shell = builder.build();
        this.status = ConnectorStatus.INITIAL;
        this.lock = new Object();
    }

    public boolean isClosed() {
        return this.status == ConnectorStatus.CLOSED;
    }

    public String open() {
        String hostName;
        if (this.status != ConnectorStatus.INITIAL) {
            throw new IllegalStateException();
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        String ret = "CRaSH " + Info.getVersion() + " (http://crsh.googlecode.com)\r\n" + "Welcome to " + hostName + "!\r\n" + "It is " + new Date() + " now.\r\n" + this.shell.getPrompt();
        this.status = ConnectorStatus.AVAILABLE;
        return ret;
    }

    public String getPrompt() {
        return this.shell.getPrompt();
    }

    public ConnectorStatus getStatus() {
        return this.status;
    }

    public void submitEvaluation(String request) {
        this.submitEvaluation(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitEvaluation(String request, CompletionHandler<String> handler) {
        1 responseHandler = new /* Unavailable Anonymous Inner Class!! */;
        Object object = this.lock;
        synchronized (object) {
            if (this.status != ConnectorStatus.AVAILABLE) {
                throw new IllegalStateException();
            }
            this.status = ConnectorStatus.EVALUATING;
            if ("bye".equals(request)) {
                this.shell.close();
                this.status = ConnectorStatus.CLOSED;
                this.futureResponse = new ImmediateFuture((Object)new ShellResponse.Ok());
            } else {
                this.futureResponse = this.shell.submitEvaluation(request, (CompletionHandler)responseHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelEvalutation() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == ConnectorStatus.EVALUATING) {
                this.status = ConnectorStatus.AVAILABLE;
                this.futureResponse.cancel(true);
                this.futureResponse = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String update(ShellResponse response) {
        Object object = this.lock;
        synchronized (object) {
            String string;
            if (this.status != ConnectorStatus.EVALUATING) {
                throw new IllegalStateException();
            }
            try {
                String ret = this.decode(response);
                this.futureResponse = null;
                this.lastLine = ret;
                string = ret;
                this.status = ConnectorStatus.AVAILABLE;
            }
            catch (Throwable throwable) {
                this.status = ConnectorStatus.AVAILABLE;
                throw throwable;
            }
            return string;
        }
    }

    public String popResponse() {
        if (this.futureResponse != null) {
            try {
                this.futureResponse.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String s = this.lastLine;
        this.lastLine = null;
        return s;
    }

    public String evaluate(String request) {
        this.submitEvaluation(request, null);
        return this.popResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            switch (2.$SwitchMap$org$crsh$connector$ConnectorStatus[this.status.ordinal()]) {
                case 1: 
                case 2: {
                    this.shell.close();
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException("todo :-)");
                }
            }
            this.status = ConnectorStatus.CLOSED;
        }
    }

    private String decode(ShellResponse response) {
        String ret = null;
        try {
            String result = null;
            if (response instanceof ShellResponse.Error) {
                ShellResponse.Error error = (ShellResponse.Error)response;
                Throwable t = error.getThrowable();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof ScriptException) {
                    result = "Error: " + t.getMessage();
                } else if (t instanceof RuntimeException) {
                    result = "Unexpected exception: " + t.getMessage();
                    t.printStackTrace(System.err);
                } else if (t instanceof Exception) {
                    result = "Unexpected exception: " + t.getMessage();
                    t.printStackTrace(System.err);
                } else {
                    result = "Unexpected throwable: " + t.getMessage();
                    t.printStackTrace(System.err);
                }
            } else if (response instanceof ShellResponse.Ok) {
                if (response instanceof ShellResponse.Display) {
                    ShellResponse.Display display = (ShellResponse.Display)response;
                    SimpleDisplayContext context = new SimpleDisplayContext("\r\n");
                    for (Element element : display) {
                        element.print((DisplayContext)context);
                    }
                    result = context.getText();
                } else {
                    result = "";
                }
            } else if (response instanceof ShellResponse.NoCommand) {
                result = "Please type something";
            } else if (response instanceof ShellResponse.UnkownCommand) {
                ShellResponse.UnkownCommand unknown = (ShellResponse.UnkownCommand)response;
                result = "Unknown command " + unknown.getName();
            }
            if (result != null) {
                ret = "" + String.valueOf(result) + "\r\n";
            }
        }
        catch (Throwable t) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            printer.print("ERROR: ");
            t.printStackTrace(printer);
            printer.println();
            printer.close();
            ret = writer.toString();
        }
        if (this.isClosed()) {
            ret = ret + "Have a good day!\r\n";
        }
        ret = ret == null ? this.shell.getPrompt() : ret + this.shell.getPrompt();
        return ret;
    }

    static /* synthetic */ ConnectorStatus access$000(ShellConnector x0) {
        return x0.status;
    }

    static /* synthetic */ String access$100(ShellConnector x0, ShellResponse x1) {
        return x0.update(x1);
    }
}

