/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.connector.sshd.scp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.sshd.server.Environment;
import org.crsh.connector.sshd.AbstractCommand;
import org.crsh.jcr.JCR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SCPCommand
extends AbstractCommand
implements Runnable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final int OK = 0;
    protected static final int ERROR = 2;
    private Thread thread;
    private Environment env;
    private final String target;

    protected SCPCommand(String target) {
        this.target = target;
    }

    final InputStream read(int length) throws IOException {
        this.log.debug("Returning stream for length " + length);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected final void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    protected final void readAck() throws IOException {
        int c = this.in.read();
        switch (c) {
            case 0: {
                break;
            }
            case 1: {
                this.log.debug("Received warning: " + this.readLine());
                break;
            }
            case 2: {
                throw new IOException("Received nack: " + this.readLine());
            }
        }
    }

    protected final String readLine() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = this.in.read()) != 10) {
            if (c == -1) {
                throw new IOException("End of stream");
            }
            baos.write(c);
        }
        return baos.toString();
    }

    public final void start(Environment env) throws IOException {
        this.env = env;
        this.thread = new Thread((Runnable)this, "CRaSH");
        this.thread.start();
    }

    public final void destroy() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void run() {
        int exitStatus = 0;
        String exitMsg = null;
        try {
            this.execute();
            if (this.callback == null) return;
        }
        catch (Exception e) {
            try {
                this.log.error("Error during command execution", (Throwable)e);
                exitMsg = e.getMessage();
                exitStatus = 2;
                if (this.callback == null) return;
            }
            catch (Throwable throwable) {
                if (this.callback == null) throw throwable;
                this.callback.onExit(exitStatus, exitMsg);
                throw throwable;
            }
            this.callback.onExit(exitStatus, exitMsg);
            return;
        }
        this.callback.onExit(exitStatus, exitMsg);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws Exception {
        String path;
        String workspaceName;
        HashMap<String, String> properties = new HashMap<String, String>();
        int pos1 = this.target.indexOf(58);
        if (pos1 != -1) {
            int pos2 = this.target.indexOf(58, pos1 + 1);
            if (pos2 != -1) {
                properties.put("exo.container.name", this.target.substring(0, pos1));
                workspaceName = this.target.substring(pos1 + 1, pos2);
                path = this.target.substring(pos2 + 1);
            } else {
                workspaceName = this.target.substring(0, pos1);
                path = this.target.substring(pos1 + 1);
            }
        } else {
            workspaceName = null;
            path = this.target;
        }
        Repository repository = JCR.getRepository(properties);
        Session session = workspaceName != null ? repository.login(workspaceName) : repository.login();
        try {
            this.execute(session, path);
        }
        finally {
            session.logout();
        }
    }

    protected abstract void execute(Session var1, String var2) throws Exception;

    static /* synthetic */ InputStream access$000(SCPCommand x0) {
        return x0.in;
    }
}

