/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.sshd;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.crsh.term.CodeType;
import org.crsh.term.TermIO;
import org.crsh.util.Safe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHIO
implements TermIO {
    private static final Logger log = LoggerFactory.getLogger(SSHIO.class);
    private static final String DEL_SEQ = "\b \b";
    private final Reader reader;
    private final Writer writer;
    private final int verase;
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_READ_ESC_1 = 1;
    private static final int STATUS_READ_ESC_2 = 2;
    private int status;

    public SSHIO(Reader reader, Writer writer, int verase) {
        this.reader = reader;
        this.writer = writer;
        this.verase = verase;
        this.status = 0;
    }

    public int read() throws IOException {
        while (true) {
            int r = this.reader.read();
            block0 : switch (this.status) {
                case 0: {
                    if (r == 27) {
                        this.status = 1;
                        break;
                    }
                    if (r == this.verase) {
                        return 1302;
                    }
                    return r;
                }
                case 1: {
                    if (r == 91) {
                        this.status = 2;
                        break;
                    }
                    this.status = 0;
                    log.error("Unrecognized stream data " + r + " after reading ESC code");
                    break;
                }
                case 2: {
                    this.status = 0;
                    switch (r) {
                        case 65: {
                            return 1001;
                        }
                        case 66: {
                            return 1002;
                        }
                        case 67: {
                            break block0;
                        }
                        case 68: {
                            break block0;
                        }
                    }
                    log.error("Unrecognized stream data " + r + " after reading ESC+91 code");
                }
            }
        }
    }

    public CodeType getType(int code) {
        switch (code) {
            case 1302: {
                return CodeType.DELETE;
            }
            case 1001: {
                return CodeType.UP;
            }
            case 1002: {
                return CodeType.DOWN;
            }
        }
        return CodeType.CHAR;
    }

    public void close() {
        Safe.close((Closeable)this.reader);
        Safe.close((Closeable)this.writer);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(String s) throws IOException {
        this.writer.write(s);
    }

    public void writeDel() throws IOException {
        this.writer.write(DEL_SEQ);
    }

    public void writeCRLF() throws IOException {
        this.writer.write("\r\n");
    }
}

