/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.telnet;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.net.Connection;
import org.crsh.term.CodeType;
import org.crsh.term.TermIO;

public class TelnetIO
implements TermIO {
    private final Connection conn;
    private final BasicTerminalIO termIO;

    public TelnetIO(Connection conn) {
        this.conn = conn;
        this.termIO = conn.getTerminalIO();
    }

    public int read() throws IOException {
        return this.termIO.read();
    }

    public CodeType getType(int code) {
        switch (code) {
            case 1302: {
                return CodeType.DELETE;
            }
            case 1001: {
                return CodeType.UP;
            }
            case 1002: {
                return CodeType.DOWN;
            }
        }
        return CodeType.CHAR;
    }

    public void close() {
        this.conn.close();
    }

    public void flush() throws IOException {
        this.termIO.flush();
    }

    public void write(String s) throws IOException {
        this.termIO.write(s);
    }

    public void writeDel() throws IOException {
        this.termIO.moveLeft(1);
        this.termIO.write(' ');
        this.termIO.moveLeft(1);
        this.termIO.flush();
    }

    public void writeCRLF() throws IOException {
        this.termIO.write("\r\n");
    }
}

