/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.crsh.util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputDecoder
implements Iterator<Input> {
    private char[] buffer = new char[128];
    private int size = 0;
    private LinkedList<Input> lines = new LinkedList();
    private int previous = -1;
    private boolean echoing = true;

    public boolean isEchoing() {
        return this.echoing;
    }

    public void setEchoing(boolean echoing) {
        this.echoing = echoing;
    }

    private void echo(char c) throws IOException {
        this.echo(new String(new char[]{c}));
    }

    private void echo(String s) throws IOException {
        if (this.echoing) {
            this.doEcho(s);
        }
    }

    private void echoDel() throws IOException {
        if (this.echoing) {
            this.doEchoDel();
        }
    }

    private void echoCRLF() throws IOException {
        if (this.echoing) {
            this.doEchoCRLF();
        }
    }

    protected abstract void doEchoCRLF() throws IOException;

    protected abstract void doEcho(String var1) throws IOException;

    protected abstract void doEchoDel() throws IOException;

    public String set(String s) throws IOException {
        StringBuilder builder = new StringBuilder();
        int i = this.appendDel();
        while (i != -1) {
            builder.append((char)i);
            i = this.appendDel();
        }
        this.appendData(s);
        return builder.reverse().toString();
    }

    public int size() {
        return this.lines.size();
    }

    public void appendData(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.appendData(s.charAt(i));
        }
    }

    public void appendData(char c) throws IOException {
        if (c == '\n' && this.previous == 13 || c == '\r' && this.previous == 10) {
            this.previous = -1;
        } else if (c == '\n' || c == '\r') {
            String line = new String(this.buffer, 0, this.size);
            this.lines.add(new Input.Chars(line));
            this.previous = c;
            this.size = 0;
            this.echoCRLF();
        } else {
            this.push(c);
            this.previous = c;
            this.echo(c);
        }
    }

    public int appendDel() throws IOException {
        int popped = this.pop();
        if (popped != -1) {
            this.previous = this.buffer[this.size];
            this.echoDel();
        } else {
            this.previous = -1;
        }
        return popped;
    }

    public int getSize() {
        return this.size;
    }

    private int pop() {
        if (this.size > 0) {
            return this.buffer[--this.size];
        }
        return -1;
    }

    @Override
    public boolean hasNext() {
        return this.lines.size() > 0;
    }

    @Override
    public Input next() {
        if (this.lines.size() > 0) {
            return (Input)this.lines.removeFirst();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void push(char c) {
        if (this.size >= this.buffer.length) {
            char[] tmp = new char[this.buffer.length * 2 + 1];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
        this.buffer[this.size++] = c;
    }
}

