/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.vfs.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginLifeCycle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private PluginContext context;
    private Properties config;

    public Properties getConfig() {
        return this.config;
    }

    public void setConfig(Properties config) {
        this.config = config;
    }

    public PluginContext getContext() {
        return this.context;
    }

    protected final void start(PluginContext context) throws IllegalStateException {
        if (this.context != null) {
            throw new IllegalStateException("Already started");
        }
        Properties config = new Properties();
        Resource res = context.loadResource("crash.properties", ResourceKind.CONFIG);
        if (res != null) {
            try {
                URL url = res.getURL();
                InputStream inputStream = url.openStream();
                config.load(inputStream);
                this.log.debug("Loaded properties from " + url + " " + config);
            }
            catch (IOException e) {
                this.log.warn("Could not configure from crash.properties", e);
            }
        } else {
            this.log.debug("Could not find crash.properties file");
        }
        if (this.config != null) {
            config.putAll((Map<?, ?>)this.config);
        }
        for (PropertyDescriptor<?> propertyDescriptor : PropertyDescriptor.ALL.values()) {
            this.configureProperty(context, config, propertyDescriptor);
        }
        for (CRaSHPlugin cRaSHPlugin : context.manager.getPlugins()) {
            for (PropertyDescriptor<?> descriptor : cRaSHPlugin.getConfigurationCapabilities()) {
                this.configureProperty(context, config, descriptor);
            }
        }
        context.start();
        this.context = context;
    }

    public final void stop() throws IllegalStateException {
        if (this.context == null) {
            throw new IllegalStateException("Not started");
        }
        PluginContext context = this.context;
        this.context = null;
        context.stop();
    }

    private void configureProperty(PluginContext context, Properties props, PropertyDescriptor<?> desc) {
        String key = "crash." + desc.name;
        String value = props.getProperty(key);
        if (value != null) {
            try {
                this.log.info("Configuring property " + desc.name + "=" + value + " from properties");
                context.setProperty(desc, value);
            }
            catch (IllegalArgumentException e) {
                this.log.error("Could not configure property", e);
            }
        }
    }
}

