/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.Collections;
import org.crsh.command.ScriptException;
import org.crsh.shell.ErrorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShellResponse {
    public static UnknownCommand unknownCommand(String name) {
        return new UnknownCommand(name);
    }

    public static NoCommand noCommand() {
        return new NoCommand();
    }

    public static Ok ok(Iterable<?> produced) {
        return new Ok(produced);
    }

    public static Ok ok() {
        return new Ok();
    }

    public static Display display(String text) {
        return new Display(text);
    }

    public static Display display(Iterable<?> produced, String text) {
        return new Display(produced, text);
    }

    public static Error evalError(Throwable throwable) {
        return new Error(ErrorType.EVALUATION, throwable);
    }

    public static Error evalError(String msg, Throwable throwable) {
        return new Error(ErrorType.EVALUATION, msg, throwable);
    }

    public static Error evalError(String msg) {
        return new Error(ErrorType.EVALUATION, msg);
    }

    public static Error internalError(Throwable throwable) {
        return new Error(ErrorType.INTERNAL, throwable);
    }

    public static Error internalError(String msg, Throwable throwable) {
        return new Error(ErrorType.INTERNAL, msg, throwable);
    }

    public static Error internalError(String msg) {
        return new Error(ErrorType.INTERNAL, msg);
    }

    public static Error error(ErrorType type, Throwable throwable) {
        return new Error(type, throwable);
    }

    public static Error error(ErrorType type, String msg, Throwable throwable) {
        return new Error(type, msg, throwable);
    }

    public static Error error(ErrorType type, String msg) {
        return new Error(type, msg);
    }

    public static Cancelled cancelled() {
        return new Cancelled();
    }

    public abstract String getText();

    public static class Error
    extends ShellResponse {
        private final ErrorType type;
        private final Throwable throwable;
        private final String msg;

        private Error(ErrorType type, Throwable throwable) {
            this.type = type;
            this.msg = Error.build(throwable);
            this.throwable = throwable;
        }

        private Error(ErrorType type, String msg) {
            this.type = type;
            this.msg = msg;
            this.throwable = null;
        }

        private Error(ErrorType type, String msg, Throwable throwable) {
            this.type = type;
            this.msg = msg;
            this.throwable = throwable;
        }

        public ErrorType getType() {
            return this.type;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String getText() {
            return this.msg;
        }

        private static String build(Throwable throwable) {
            String msg = throwable.getMessage();
            if (msg == null) {
                msg = throwable.getClass().getSimpleName();
            }
            String result = throwable instanceof ScriptException ? "Error: " + msg : (throwable instanceof RuntimeException ? "Unexpected exception: " + msg : (throwable instanceof Exception ? "Unexpected exception: " + msg : (throwable instanceof java.lang.Error ? "Unexpected error: " + msg : "Unexpected throwable: " + msg)));
            return result;
        }

        public String toString() {
            return "ShellResponse.Error[type=" + (Object)((Object)this.type) + ",msg=" + this.msg + "]";
        }
    }

    public static class Cancelled
    extends ShellResponse {
        private Cancelled() {
        }

        public String getText() {
            return "cancelled";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Display
    extends Ok {
        private final String text;

        private Display(String text) {
            this.text = text;
        }

        private Display(Iterable<?> produced, String text) {
            super(produced);
            this.text = text;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Display) {
                Display that = (Display)obj;
                return this.text.equals(that.text);
            }
            return false;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ok
    extends ShellResponse {
        private final Iterable<?> produced;

        private Ok() {
            this(Collections.emptyList());
        }

        private Ok(Iterable<?> produced) {
            this.produced = produced;
        }

        public Iterable<?> getProduced() {
            return this.produced;
        }

        @Override
        public String getText() {
            return "";
        }
    }

    public static class Close
    extends ShellResponse {
        public String getText() {
            return "Have a good day!\r\n";
        }
    }

    public static class NoCommand
    extends ShellResponse {
        private NoCommand() {
        }

        public String getText() {
            return "Please type something";
        }
    }

    public static class UnknownCommand
    extends ShellResponse {
        private final String name;

        private UnknownCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return "Unknown command " + this.name;
        }
    }
}

