/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path
implements Iterable<String> {
    private final boolean dir;
    private final String[] names;
    private String value;

    public static Path get(Path parent, String name, boolean dir) {
        if (!parent.dir) {
            throw new IllegalArgumentException("Not a dir");
        }
        int length = parent.names.length;
        String[] names = new String[length + 1];
        System.arraycopy(parent.names, 0, names, 0, length);
        names[length] = name;
        return new Path(dir, names);
    }

    public static Path get(String s) {
        boolean dir;
        if (s.length() == 0) {
            throw new IllegalArgumentException("No empty path");
        }
        if (s.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must begin with a '/'");
        }
        int end = s.length();
        int count = 0;
        int prev = 1;
        while (true) {
            int next;
            if ((next = s.indexOf(47, prev)) == -1) {
                if (prev >= end) break;
                ++count;
                break;
            }
            if (next - prev > 0) {
                ++count;
            }
            prev = next + 1;
        }
        String[] names = new String[count];
        prev = 1;
        count = 0;
        while (true) {
            int next;
            if ((next = s.indexOf(47, prev)) == -1) {
                if (prev < end) {
                    names[count] = s.substring(prev);
                    dir = false;
                    break;
                }
                dir = true;
                break;
            }
            if (next - prev > 0) {
                names[count++] = s.substring(prev, next);
            }
            prev = next + 1;
        }
        return new Path(dir, names);
    }

    private Path(boolean dir, String[] names) {
        this.dir = dir;
        this.names = names;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Path.this.names.length;
            }

            @Override
            public String next() {
                if (this.index < Path.this.names.length) {
                    return Path.this.names[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getSize() {
        return this.names.length;
    }

    public boolean isDir() {
        return this.dir;
    }

    public String getName() {
        return this.names.length > 0 ? this.names[this.names.length - 1] : "";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Path) {
            Path that = (Path)o;
            return this.dir == that.dir && super.equals(that);
        }
        return false;
    }

    public String getValue() {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder(8 * this.names.length);
            for (String name : this.names) {
                sb.append('/').append(name);
            }
            if (this.dir) {
                sb.append('/');
            }
            this.value = sb.toString();
        }
        return this.value;
    }

    public int hashCode() {
        return super.hashCode() ^ (this.dir ? 1 : 0);
    }

    public String toString() {
        return "Path[value=" + this.getValue() + "]";
    }
}

