/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.mount;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.AbstractFSDriver;
import org.crsh.vfs.spi.FSDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MountDriver<H>
extends AbstractFSDriver<H> {
    private final Path path;
    private final FSDriver<H> driver;

    public MountDriver(Path path, FSDriver<H> driver) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (driver == null) {
            throw new NullPointerException();
        }
        if (!path.isDir()) {
            throw new IllegalArgumentException("Mount path must be a dir");
        }
        this.path = path;
        this.driver = driver;
    }

    @Override
    public H root() throws IOException {
        String name;
        H root = this.driver.root();
        Iterator<String> i$ = this.path.iterator();
        while (i$.hasNext() && (root = this.driver.child(root, name = i$.next())) != null) {
        }
        return root;
    }

    @Override
    public String name(H handle) throws IOException {
        return this.driver.name(handle);
    }

    @Override
    public boolean isDir(H handle) throws IOException {
        return this.driver.isDir(handle);
    }

    @Override
    public Iterable<H> children(H handle) throws IOException {
        return this.driver.children(handle);
    }

    @Override
    public URL toURL(H handle) throws IOException {
        return this.driver.toURL(handle);
    }
}

