/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.spi.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.net.Done;
import org.crsh.util.AbstractSocketServer;

public class TermIOServer
extends AbstractSocketServer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final TermIO delegate;
    private InputStream in;
    private OutputStream out;

    public TermIOServer(TermIO delegate, int bindingPort) {
        super(bindingPort);
        this.delegate = delegate;
    }

    protected void handle(InputStream in, OutputStream out) throws IOException {
        this.in = in;
        this.out = out;
    }

    private byte read() throws IOException, Done {
        int b = this.in.read();
        if (b == -1) {
            throw new Done();
        }
        return (byte)b;
    }

    private int read(byte[] buffer, int off, int len) throws IOException, Done {
        int b = this.in.read(buffer, off, len);
        if (b == -1) {
            throw new Done();
        }
        return b;
    }

    private void write(byte b) throws IOException, Done {
        this.out.write(b);
    }

    private void write(byte[] bytes) throws IOException, Done {
        this.out.write(bytes);
    }

    private void flush() throws IOException, Done {
        this.out.flush();
    }

    public boolean execute() throws IOException, IllegalStateException {
        if (this.in == null) {
            throw new IllegalStateException("No connection");
        }
        try {
            this.iterate();
            return true;
        }
        catch (Done ignore) {
            this.in = null;
            this.out = null;
            this.close();
            return false;
        }
    }

    private void iterate() throws IOException, Done {
        byte b = this.read();
        if (b == 0) {
            int code = this.delegate.read();
            CodeType codeType = this.delegate.decode(code);
            byte ordinal = (byte)codeType.ordinal();
            if (codeType == CodeType.CHAR) {
                this.write(new byte[]{ordinal, (byte)((code & 0xFF00) >> 8), (byte)(code & 0xFF)});
            } else {
                this.write(ordinal);
            }
            this.flush();
        } else if (b == 1) {
            int b1 = this.in.read();
            int b2 = this.in.read();
            char c = (char)((b1 << 8) + b2);
            this.delegate.write(c);
        } else if (b == 2) {
            int r;
            int remaining;
            b = this.read();
            int offset = 0;
            byte[] buffer = new byte[remaining];
            for (remaining = (b + 2) * 2; remaining > 0; remaining -= r) {
                r = this.read(buffer, offset, remaining);
                offset += r;
            }
            char[] chars = new char[buffer.length / 2];
            int index = 0;
            for (int i = 0; i < chars.length; ++i) {
                byte high = buffer[index++];
                byte low = buffer[index++];
                chars[i] = (char)((high << 8) + low);
            }
            String s = new String(chars);
            this.delegate.write(s);
        } else if (b == 3) {
            this.delegate.writeDel();
        } else if (b == 4) {
            this.delegate.writeCRLF();
        } else if (b == 5) {
            int b1 = this.in.read();
            int b2 = this.in.read();
            char c = (char)((b1 << 8) + b2);
            this.delegate.moveRight(c);
        } else if (b == 6) {
            this.delegate.moveLeft();
        } else if (b == 7) {
            this.delegate.flush();
        } else if (b == 8) {
            int len = this.read() + 1;
            byte[] bytes = new byte[len];
            this.read(bytes, 0, len);
            String propertyName = new String(bytes, UTF_8);
            String propertyValue = "width".equals(propertyName) ? Integer.toString(this.delegate.getWidth()) : this.delegate.getProperty(propertyName);
            if (propertyValue == null) {
                this.write((byte)0);
            } else if (propertyValue.length() == 0) {
                this.write((byte)1);
            } else {
                bytes = propertyValue.getBytes(UTF_8);
                len = bytes.length;
                if (len > 254) {
                    this.write((byte)0);
                } else {
                    this.write((byte)(len + 1));
                    this.write(bytes);
                }
                this.flush();
            }
        } else {
            throw new UnsupportedOperationException("cannot handle " + b);
        }
    }
}

