/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.tokenizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.matcher.tokenizer.Escape;
import org.crsh.cmdline.matcher.tokenizer.State;
import org.crsh.cmdline.matcher.tokenizer.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer
implements Iterator<Token> {
    private final CharSequence s;
    private int index;
    private ArrayList<Token> stack;
    private int ptr;
    private Delimiter delimiter;

    public Tokenizer(CharSequence s) {
        this.s = s;
        this.stack = new ArrayList();
        this.index = 0;
        this.delimiter = null;
    }

    @Override
    public boolean hasNext() {
        if (this.ptr < this.stack.size()) {
            return true;
        }
        Token next = this.parse();
        if (next != null) {
            this.stack.add(next);
        }
        return next != null;
    }

    private Token parse() {
        Token token = null;
        if (this.index < this.s.length()) {
            char c = this.s.charAt(this.index);
            int from = this.index;
            while (Character.isWhitespace(c)) {
                ++this.index;
                if (this.index >= this.s.length()) break;
                c = this.s.charAt(this.index);
            }
            if (this.index > from) {
                token = new Token.Whitespace(from, ((Object)this.s.subSequence(from, this.index)).toString());
            } else {
                State state = new State();
                while (!Character.isWhitespace(c) || state.escape != Escape.NONE) {
                    ++this.index;
                    state.push(c);
                    if (this.index >= this.s.length()) break;
                    c = this.s.charAt(this.index);
                }
                if (this.index > from) {
                    switch (state.status) {
                        case INIT: {
                            token = new Token.Literal.Word(from, ((Object)this.s.subSequence(from, this.index)).toString(), state.buffer.toString());
                            break;
                        }
                        case WORD: {
                            token = new Token.Literal.Word(from, ((Object)this.s.subSequence(from, this.index)).toString(), state.buffer.toString());
                            break;
                        }
                        case SHORT_OPTION: {
                            token = new Token.Literal.Option.Short(from, ((Object)this.s.subSequence(from, this.index)).toString(), state.buffer.toString());
                            break;
                        }
                        case LONG_OPTION: {
                            token = new Token.Literal.Option.Long(from, ((Object)this.s.subSequence(from, this.index)).toString(), state.buffer.toString());
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)state.status);
                        }
                    }
                    this.delimiter = state.escape.delimiter;
                    return token;
                }
            }
        }
        return token;
    }

    @Override
    public Token next() {
        if (this.hasNext()) {
            return this.stack.get(this.ptr++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getIndex() {
        Token peek = this.peek();
        if (peek != null) {
            return peek.getFrom();
        }
        return this.index;
    }

    public void pushBack() {
        this.pushBack(1);
    }

    public void pushBack(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (this.ptr - count < 0) {
            throw new IllegalStateException("Trying to push back too many tokens");
        }
        this.ptr -= count;
    }

    public Token peek() {
        if (this.hasNext()) {
            return this.stack.get(this.ptr);
        }
        return null;
    }

    public Delimiter getDelimiter() {
        return this.delimiter;
    }
}

