/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import groovy.util.BuilderSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.LabelElement;
import org.crsh.shell.ui.RowElement;
import org.crsh.shell.ui.TableElement;
import org.crsh.shell.ui.TreeElement;
import org.crsh.text.Color;
import org.crsh.text.Decoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIBuilder
extends BuilderSupport {
    private final List<Element> elements = new ArrayList<Element>();

    public List<Element> getElements() {
        return this.elements;
    }

    @Override
    protected Object createNode(Object name) {
        return this.createNode(name, (Object)null);
    }

    @Override
    protected Object createNode(Object name, Object value) {
        return this.initElement(name, value);
    }

    @Override
    protected Object createNode(Object name, Map attributes, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object createNode(Object name, Map attributes) {
        Element e = this.initElement(name, attributes.get("value"));
        this.setStyles(e, attributes);
        Boolean border = (Boolean)attributes.get("border");
        if (e instanceof TableElement) {
            ((TableElement)e).setBorder(border == null ? false : border);
        }
        return e;
    }

    private Element initElement(Object name, Object value) {
        if ("node".equals(name)) {
            if (value == null) {
                return new TreeElement();
            }
            return new TreeElement(new LabelElement(value));
        }
        if ("label".equals(name)) {
            return new LabelElement(value);
        }
        if ("table".equals(name)) {
            return new TableElement();
        }
        if ("row".equals(name)) {
            return new RowElement();
        }
        if ("header".equals(name)) {
            return new RowElement(true);
        }
        throw new UnsupportedOperationException("Cannot build object with name " + name + " and value " + value);
    }

    private void setStyles(Element e, Map attributes) {
        e.setDecoration((Decoration)attributes.get("decoration"));
        e.setForeground((Color)attributes.get("foreground"));
        e.setBackground((Color)attributes.get("background"));
    }

    @Override
    protected void setParent(Object parent, Object child) {
        if (parent instanceof TreeElement) {
            TreeElement parentElement = (TreeElement)parent;
            Element childElement = (Element)child;
            parentElement.addNode(childElement);
            childElement.setParent(parentElement);
        } else if (parent instanceof TableElement) {
            TableElement parentElement = (TableElement)parent;
            RowElement childElement = (RowElement)child;
            parentElement.addRow(childElement);
            childElement.setParent(parentElement);
        } else if (parent instanceof RowElement) {
            RowElement parentElement = (RowElement)parent;
            Element childElement = (Element)child;
            if (child instanceof TreeElement) {
                throw new IllegalArgumentException("A table cannot contain node element");
            }
            parentElement.addValue(childElement);
            childElement.setParent(parentElement);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected void nodeCompleted(Object parent, Object child) {
        if (parent == null) {
            this.elements.add((Element)child);
        }
        super.nodeCompleted(parent, child);
    }
}

