/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.Pipe;
import org.crsh.command.CommandInvoker;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.PipeCommand;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.command.CRaSHInvocationContext;
import org.crsh.shell.impl.command.CRaSHProcess;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.text.Chunk;
import org.crsh.text.ChunkAdapter;
import org.crsh.text.ChunkBuffer;
import org.crsh.text.RenderingContext;

class PipeLine {
    final String line;
    final String name;
    final String rest;
    private ShellCommand command;
    private CommandInvoker invoker;
    final PipeLine next;

    public String getLine() {
        return this.line;
    }

    PipeLine(String line, PipeLine next) {
        Pattern p = Pattern.compile("^\\s*(\\S+)");
        Matcher m = p.matcher(line);
        String name = null;
        String rest = null;
        if (m.find()) {
            name = m.group(1);
            rest = line.substring(m.end());
        }
        this.name = name;
        this.rest = rest;
        this.line = line;
        this.next = next;
    }

    PipeLine getLast() {
        if (this.next != null) {
            return this.next.getLast();
        }
        return this;
    }

    CRaSHProcess create(CRaSHSession session, String request) throws NoSuchCommandException {
        CommandInvoker<?, ?> invoker = null;
        if (this.name != null) {
            this.command = session.crash.getCommand(this.name);
            if (this.command != null) {
                invoker = this.command.resolveInvoker(this.rest);
            }
        }
        if (invoker == null) {
            throw new NoSuchCommandException(this.name);
        }
        this.invoker = invoker;
        if (this.next != null) {
            this.next.create(session, request);
        }
        return new CRaSHProcess(session, request){

            ShellResponse doInvoke(ShellProcessContext context) throws InterruptedException {
                PipeProxy proxy = new PipeProxy(this.crash, context, PipeLine.this);
                try {
                    proxy.open();
                    proxy.flush();
                    proxy.close();
                }
                catch (ScriptException e) {
                    return PipeLine.this.build(e);
                }
                catch (Throwable t) {
                    return PipeLine.this.build(t);
                }
                return ShellResponse.ok();
            }
        };
    }

    private ShellResponse.Error build(Throwable throwable) {
        String result;
        ErrorType errorType;
        if (throwable instanceof ScriptException) {
            errorType = ErrorType.EVALUATION;
            Throwable cause = throwable.getCause();
            if (cause != null) {
                throwable = cause;
            }
        } else {
            errorType = ErrorType.INTERNAL;
        }
        String msg = throwable.getMessage();
        if (throwable instanceof ScriptException) {
            result = msg == null ? this.name + ": failed" : this.name + ": " + msg;
            return ShellResponse.error(errorType, result, throwable);
        }
        if (msg == null) {
            msg = throwable.getClass().getSimpleName();
        }
        result = throwable instanceof RuntimeException ? this.name + ": exception: " + msg : (throwable instanceof Exception ? this.name + ": exception: " + msg : (throwable instanceof Error ? this.name + ": error: " + msg : this.name + ": unexpected throwable: " + msg));
        return ShellResponse.error(errorType, result, throwable);
    }

    private static class PipeProxy
    extends PipeCommand {
        private final CRaSHSession session;
        private final ShellProcessContext context;
        private final PipeLine pipeLine;
        private Pipe next;
        private PipeCommand command;

        private PipeProxy(CRaSHSession session, ShellProcessContext context, PipeLine pipeLine) {
            this.session = session;
            this.context = context;
            this.pipeLine = pipeLine;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void open() throws ScriptException {
            if (this.pipeLine.next != null) {
                PipeProxy proxy;
                if (this.pipeLine.invoker.getProducedType() == Chunk.class) {
                    if (this.pipeLine.next.invoker.getConsumedType() != Chunk.class) throw new UnsupportedOperationException("Not supported yet");
                    proxy = new PipeProxy(this.session, this.context, this.pipeLine.next);
                    proxy.setPiped(true);
                    this.next = proxy;
                    proxy.open();
                } else if (this.pipeLine.invoker.getProducedType().isAssignableFrom(this.pipeLine.next.invoker.getConsumedType())) {
                    proxy = new PipeProxy(this.session, this.context, this.pipeLine.next);
                    proxy.setPiped(true);
                    this.next = proxy;
                    proxy.open();
                } else {
                    proxy = new PipeProxy(this.session, this.context, this.pipeLine.next);
                    proxy.setPiped(true);
                    proxy.open();
                    this.next = new ChunkAdapter(new RenderingContext(){

                        public int getWidth() {
                            return PipeProxy.this.context.getWidth();
                        }

                        public void provide(Chunk element) throws IOException {
                            proxy.provide(element);
                        }

                        public void flush() throws IOException {
                            proxy.flush();
                        }
                    });
                }
            } else {
                final ChunkBuffer buffer = new ChunkBuffer(this.context);
                this.next = new ChunkAdapter(new RenderingContext(){

                    public int getWidth() {
                        return PipeProxy.this.context.getWidth();
                    }

                    public void provide(Chunk element) throws IOException {
                        buffer.provide(element);
                    }

                    public void flush() throws IOException {
                        buffer.flush();
                    }
                });
            }
            CRaSHInvocationContext invocationContext = new CRaSHInvocationContext(this.context, this.session, this.session.crash.getContext().getAttributes(), this.next);
            this.command = this.pipeLine.invoker.invoke(invocationContext);
            this.command.setPiped(this.isPiped());
            this.command.open();
        }

        public void provide(Object element) throws IOException {
            if (this.pipeLine.invoker.getConsumedType().isInstance(element)) {
                this.command.provide(element);
            }
        }

        public void flush() throws IOException {
            this.command.flush();
            this.next.flush();
        }

        public void close() throws ScriptException {
            this.command.close();
        }
    }
}

