/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.IOException;
import java.util.LinkedList;
import org.crsh.Pipe;
import org.crsh.text.Chunk;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderable;
import org.crsh.text.Renderer;
import org.crsh.text.RenderingContext;
import org.crsh.text.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkAdapter
implements Pipe<Object> {
    private final LinkedList<Object> buffer = new LinkedList();
    private Renderable renderable = null;
    private final RenderAppendable out;

    public ChunkAdapter(RenderingContext out) {
        this.out = new RenderAppendable(out);
    }

    @Override
    public void provide(Object element) throws IOException {
        Renderable<?> current = Renderable.getRenderable(element.getClass());
        if (current == null) {
            this.send();
            if (element instanceof Chunk) {
                this.out.provide((Chunk)element);
            } else {
                this.out.provide(new Text(element.toString()));
            }
        } else {
            if (this.renderable != null && !current.equals(this.renderable)) {
                this.send();
            }
            this.buffer.addLast(element);
            this.renderable = current;
        }
    }

    @Override
    public void flush() throws IOException {
        this.send();
        this.out.flush();
    }

    public void send() throws IOException {
        if (this.buffer.size() > 0) {
            Renderer renderer = this.renderable.renderer(this.buffer.iterator());
            renderer.render(this.out);
            this.buffer.clear();
            this.renderable = null;
        }
    }
}

