/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.LabelElement;

class LabelRenderer
extends Renderer {
    private final LabelElement label;

    LabelRenderer(LabelElement label) {
        this.label = label;
    }

    public int getMinWidth() {
        return this.label.minWidth;
    }

    public int getActualWidth() {
        return this.label.width;
    }

    public LineReader renderer(final int width) {
        if (width == 0) {
            return new LineReader(){
                boolean done = false;

                public boolean hasLine() {
                    return !this.done;
                }

                public void renderLine(RenderAppendable to) throws IllegalStateException {
                    if (this.done) {
                        throw new IllegalStateException();
                    }
                    this.done = true;
                }
            };
        }
        return new LineReader(){
            boolean done = false;
            int index = 0;

            public boolean hasLine() {
                return !this.done;
            }

            public void renderLine(RenderAppendable to) {
                int pos;
                if (this.done) {
                    throw new IllegalStateException();
                }
                Style.Composite style = LabelRenderer.this.label.getStyle();
                if (style != null) {
                    to.enterStyle(style);
                }
                int next = (pos = ((LabelRenderer)LabelRenderer.this).label.value.indexOf(10, this.index)) == -1 ? (pos = Math.min(this.index + width, ((LabelRenderer)LabelRenderer.this).label.value.length())) : (pos <= this.index + width ? pos + 1 : (pos = this.index + width));
                to.append(((LabelRenderer)LabelRenderer.this).label.value, this.index, pos);
                for (int missing = pos - this.index; missing < width; ++missing) {
                    to.append(' ');
                }
                this.index = next;
                boolean bl = this.done = this.index >= ((LabelRenderer)LabelRenderer.this).label.value.length();
                if (style != null) {
                    to.leaveStyle();
                }
            }
        };
    }
}

