/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.LinkedList;

public class PipedChannel {
    private final LinkedList<Integer> queue = new LinkedList();
    private final Object lock = new Object();
    private boolean closed = false;
    private InputStream in = new InputStream();
    private OutputStream out = new OutputStream();

    public InputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }

    class OutputStream
    extends java.io.OutputStream {
        OutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            Object object = PipedChannel.this.lock;
            synchronized (object) {
                if (PipedChannel.this.closed) {
                    throw new IOException("closed");
                }
                PipedChannel.this.queue.add(b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object = PipedChannel.this.lock;
            synchronized (object) {
                if (PipedChannel.this.closed) {
                    throw new IOException("closed");
                }
                PipedChannel.this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = PipedChannel.this.lock;
            synchronized (object) {
                if (!PipedChannel.this.closed) {
                    PipedChannel.this.closed = true;
                    PipedChannel.this.lock.notifyAll();
                }
            }
        }
    }

    class InputStream
    extends java.io.InputStream {
        InputStream() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read() throws IOException {
            Object object = PipedChannel.this.lock;
            synchronized (object) {
                while (PipedChannel.this.queue.size() <= 0) {
                    if (PipedChannel.this.closed) {
                        throw new IOException("closed");
                    }
                    try {
                        PipedChannel.this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        InterruptedIOException iioe = new InterruptedIOException();
                        iioe.initCause(e);
                        throw iioe;
                    }
                }
                return (Integer)PipedChannel.this.queue.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = PipedChannel.this.lock;
            synchronized (object) {
                if (!PipedChannel.this.closed) {
                    PipedChannel.this.closed = true;
                    PipedChannel.this.lock.notifyAll();
                }
            }
        }
    }
}

