/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.spi;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueCompletion
implements Iterable<Map.Entry<String, Boolean>>,
Serializable {
    private final String prefix;
    private final Map<String, Boolean> entries;

    public static ValueCompletion create() {
        return new ValueCompletion();
    }

    public static ValueCompletion create(String prefix) {
        return new ValueCompletion(prefix);
    }

    public static ValueCompletion create(String prefix, String suffix, boolean value) {
        ValueCompletion result = new ValueCompletion(prefix);
        result.put(suffix, value);
        return result;
    }

    public static ValueCompletion create(String suffix, boolean value) {
        ValueCompletion result = new ValueCompletion();
        result.put(suffix, value);
        return result;
    }

    public ValueCompletion() {
        this("");
    }

    public ValueCompletion(String prefix) {
        this(prefix, new LinkedHashMap<String, Boolean>());
    }

    public ValueCompletion(String prefix, Map<String, Boolean> entries) {
        if (prefix == null) {
            throw new NullPointerException("No null prefix allowed");
        }
        if (entries == null) {
            throw new NullPointerException("No null values allowed");
        }
        this.prefix = prefix;
        this.entries = entries;
    }

    @Override
    public Iterator<Map.Entry<String, Boolean>> iterator() {
        return this.entries.entrySet().iterator();
    }

    public Set<String> getSuffixes() {
        return this.entries.keySet();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public Object get(String key) {
        return this.entries.get(key);
    }

    public int getSize() {
        return this.entries.size();
    }

    public ValueCompletion put(String key, boolean value) {
        this.entries.put(key, value);
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int hashCode() {
        return this.prefix.hashCode() ^ ((Object)this.entries).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ValueCompletion) {
            ValueCompletion that = (ValueCompletion)obj;
            return this.prefix.equals(that.prefix) && ((Object)this.entries).equals(that.entries);
        }
        return false;
    }

    public String toString() {
        return "Completion[prefix=" + this.prefix + ",entries=" + this.entries + "]";
    }
}

